/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCSystemeParticule.h									*/
/*																		*/
/* Start Date   :05/25/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXSYSTEMEPARTICULE_H__
#define __EXSYSTEMEPARTICULE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
#include "Math/ExCRandomNumber.h"
#include "Math/ExCFrustum.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "ExCParticule.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerCollision.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
//Define
//------------------------------------------------------------------------
#define EMMETEUR_POINT			1
#define EMMETEUR_LIGNE			2
#define EMMETEUR_RECTANGLE		3
#define EMMETEUR_CUBE			4
#define EMMETEUR_CERCLE			5
#define EMMETEUR_SPIRAL			6
#define EMMETEUR_DISQUE			7
//------------------------------------------------------------------------

class ExCSystemeParticule : public ExCObject3D 
{
protected:
	ExManagerCollision			*ManagerCollision;
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	std::vector<ExCParticule>			m_VecParticule;
	std::vector<ExCParticule>::iterator m_ItVecParticule;


	bool				m_State;
	bool				m_Pause;
	
	float				m_TimeLastParticule;
	char				*m_ParticuleSystemeName;

	//Param for emmeteur
	float				m_EmissionRate;
	unsigned int		m_MaxParticule;
	int					m_TypeEmmeteur;
	ExCVec3D			m_P1;//use for point
	ExCVec3D			m_P2;//use for line
	float				m_rayon;
	int					m_angle;
	int					m_vitesseangle;
	//Max and min value for particule
	int				m_Type;
	std::string		m_TextureName;
	int				m_MaxLifeSpan;
	int				m_MinLifeSpan;
	float				m_MaxGrowth;
	float				m_MinGrowth;
	float			m_MaxSize;
	float			m_MinSize;
	int				m_MaxWeight;
	int				m_MinWeight;
	int				m_MaxColorR;
	int				m_MinColorR;
	int				m_MaxColorG;
	int				m_MinColorG;
	int				m_MaxColorB;
	int				m_MinColorB;
	int				m_MaxBlending;
	int				m_MinBlending;
	ExCVec3D		m_MaxVelocity;
	ExCVec3D		m_MinVelocity;
	ExCVec3D		m_MaxAcceleration;
	ExCVec3D		m_MinAcceleration;
	ExCVec3D		m_MaxGravity;
	ExCVec3D		m_MinGravity;
	
	ExCVec3D		m_CurrentEmitPosition;
	
	float			m_MaxRotation;
	float			m_MinRotation;

	void CalculateEmitPosition(void);
	void CreateNewParticle(void);

public:
	//struct for bmp
	GLuint				m_TextureID;
	ExManagerTexture	*ManagerTexture;
	std::ostrstream *Consol;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCSystemeParticule(void);
	~ExCSystemeParticule(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerCollision(ExManagerCollision * Collision){ManagerCollision = Collision;}

	inline void SetEmitterType(int value){m_TypeEmmeteur=value;}
	inline void SetMaxParticule(int value){m_MaxParticule=value;}
	inline void SetRange(float value){m_rayon=value;}
	inline void SetSpeedAngle(int value){m_vitesseangle=value;}
	inline void SetRate(int value){m_EmissionRate=value;}

	inline int GetEmitterType(void){return m_TypeEmmeteur;}
	inline int GetMaxParticule(void){return m_MaxParticule;}
	inline float GetRange(void){return m_rayon;}
	inline int GetSpeedAngle(void){return m_vitesseangle;}
	inline int GetRate(void){return m_EmissionRate;}

	void Draw(void);
	void Start(void);
	void Pause(void);
	void Stop(void);

	bool Load(std::string FileName);
	bool Save(std::string  FileName);

	inline char * GetParticuleSystemeName(void){return m_ParticuleSystemeName;}
	void SetParticuleSystemeName(char * name);

	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline bool GetParticuleSystemeState(void){return m_State;}
	inline void SetParticuleSystemeState(bool state){m_State=state;}
	
	void SetParticuleType(int type);
	inline int GetParticuleType(void){return m_Type;}
	
	void SetParticuleTexture(std::string Name);
	void SetParticuleTextureName(std::string Name){m_TextureName=Name;}
	inline std::string GetParticuleTexture(void){return m_TextureName;}

	inline void SetParticuleMaxLife(int life) {m_MaxLifeSpan=life;}
	inline int	GetParticuleMaxLife(void)	{return m_MaxLifeSpan;}
	inline void SetParticuleMinLife(int life) {m_MinLifeSpan=life;}
	inline int	GetParticuleMinLife(void)	{return m_MinLifeSpan;}

	inline void SetParticuleMaxGrowth(float Growth) {m_MaxGrowth =Growth;}
	inline float	GetParticuleMaxGrowth(void)	{return m_MaxGrowth ;}
	inline void SetParticuleMinGrowth(float Growth) {m_MinGrowth =Growth;}
	inline float	GetParticuleMinGrowth(void)	{return m_MinGrowth ;}

	inline void SetParticuleMaxSize(float Size) {m_MaxSize=Size;}
	inline float	GetParticuleMaxSize(void)	{return m_MaxSize;}
	inline void SetParticuleMinSize(float Size) {m_MinSize=Size;}
	inline float	GetParticuleMinSize(void)	{return m_MinSize;}
	
	
	inline void SetParticuleMaxWeight(int Weight) {m_MaxWeight=Weight;}
	inline int	GetParticuleMaxWeight(void)	{return m_MaxWeight;}
	inline void SetParticuleMinWeight(int Weight) {m_MinWeight=Weight;}
	inline int	GetParticuleMinWeight(void)	{return m_MinWeight;}
	
	inline void SetParticuleMaxColorR(int ColorR) {m_MaxColorR=ColorR;}
	inline int	GetParticuleMaxColorR(void)	{return m_MaxColorR;}
	inline void SetParticuleMinColorR(int ColorR) {m_MinColorR=ColorR;}
	inline int	GetParticuleMinColorR(void)	{return m_MinColorR;}

	inline void SetParticuleMaxColorG(int ColorG) {m_MaxColorG=ColorG;}
	inline int	GetParticuleMaxColorG(void)	{return m_MaxColorG;}
	inline void SetParticuleMinColorG(int ColorG) {m_MinColorG=ColorG;}
	inline int	GetParticuleMinColorG(void)	{return m_MinColorG;}

	inline void SetParticuleMaxColorB(int ColorB) {m_MaxColorB=ColorB;}
	inline int	GetParticuleMaxColorB(void)	{return m_MaxColorB;}
	inline void SetParticuleMinColorB(int ColorB) {m_MinColorB=ColorB;}
	inline int	GetParticuleMinColorB(void)	{return m_MinColorB;}

	inline void SetParticuleMaxBlending(int Blending) {m_MaxBlending=Blending;}
	inline int	GetParticuleMaxBlending(void)	{return m_MaxBlending;}
	inline void SetParticuleMinBlending(int Blending) {m_MinBlending=Blending;}
	inline int	GetParticuleMinBlending(void)	{return m_MinBlending;}

	inline void SetParticuleMaxVelocity(ExCVec3D Velocity) {m_MaxVelocity=Velocity;}
	inline ExCVec3D	GetParticuleMaxVelocity(void)	{return m_MaxVelocity;}
	inline void SetParticuleMinVelocity(ExCVec3D Velocity) {m_MinVelocity=Velocity;}
	inline ExCVec3D	GetParticuleMinVelocity(void)	{return m_MinVelocity;}

	inline void SetParticuleMaxAcceleration(ExCVec3D Acceleration) {m_MaxAcceleration=Acceleration;}
	inline ExCVec3D	GetParticuleMaxAcceleration(void)	{return m_MaxAcceleration;}
	inline void SetParticuleMinAcceleration(ExCVec3D Acceleration) {m_MinAcceleration=Acceleration;}
	inline ExCVec3D	GetParticuleMinAcceleration(void)	{return m_MinAcceleration;}

	//-------------------------------------------------------
	inline void		SetEmitterP1X(float P1)	{m_P1.SetX(P1);}
	inline float	GetEmitterP1X(void)		{return m_P1.GetX();}
	inline void		SetEmitterP1Y(float P1)	{m_P1.SetY(P1);}
	inline float	GetEmitterP1Y(void)		{return m_P1.GetY();}
	inline void		SetEmitterP1Z(float P1)	{m_P1.SetZ(P1);}
	inline float	GetEmitterP1Z(void)		{return m_P1.GetZ();}

	inline void		SetEmitterP2X(float P2)	{m_P2.SetX(P2);}
	inline float	GetEmitterP2X(void)		{return m_P2.GetX();}
	inline void		SetEmitterP2Y(float P2)	{m_P2.SetY(P2);}
	inline float	GetEmitterP2Y(void)		{return m_P2.GetY();}
	inline void		SetEmitterP2Z(float P2)	{m_P2.SetZ(P2);}
	inline float	GetEmitterP2Z(void)		{return m_P2.GetZ();}
	//-------------------------------------------------------
	inline void		SetEmitterMaxGravityX(float MaxGravity)	{m_MaxGravity.SetX(MaxGravity);}
	inline float	GetEmitterMaxGravityX(void)		{return m_MaxGravity.GetX();}
	inline void		SetEmitterMaxGravityY(float MaxGravity)	{m_MaxGravity.SetY(MaxGravity);}
	inline float	GetEmitterMaxGravityY(void)		{return m_MaxGravity.GetY();}
	inline void		SetEmitterMaxGravityZ(float MaxGravity)	{m_MaxGravity.SetZ(MaxGravity);}
	inline float	GetEmitterMaxGravityZ(void)		{return m_MaxGravity.GetZ();}

	inline void		SetEmitterMinGravityX(float MinGravity)	{m_MinGravity.SetX(MinGravity);}
	inline float	GetEmitterMinGravityX(void)		{return m_MinGravity.GetX();}
	inline void		SetEmitterMinGravityY(float MinGravity)	{m_MinGravity.SetY(MinGravity);}
	inline float	GetEmitterMinGravityY(void)		{return m_MinGravity.GetY();}
	inline void		SetEmitterMinGravityZ(float MinGravity)	{m_MinGravity.SetZ(MinGravity);}
	inline float	GetEmitterMinGravityZ(void)		{return m_MinGravity.GetZ();}
	//-------------------------------------------------------
	inline void		SetEmitterMaxAccelerationX(float MaxAcceleration)	{m_MaxAcceleration.SetX(MaxAcceleration);}
	inline float	GetEmitterMaxAccelerationX(void)		{return m_MaxAcceleration.GetX();}
	inline void		SetEmitterMaxAccelerationY(float MaxAcceleration)	{m_MaxAcceleration.SetY(MaxAcceleration);}
	inline float	GetEmitterMaxAccelerationY(void)		{return m_MaxAcceleration.GetY();}
	inline void		SetEmitterMaxAccelerationZ(float MaxAcceleration)	{m_MaxAcceleration.SetZ(MaxAcceleration);}
	inline float	GetEmitterMaxAccelerationZ(void)		{return m_MaxAcceleration.GetZ();}

	inline void		SetEmitterMinAccelerationX(float MinAcceleration)	{m_MinAcceleration.SetX(MinAcceleration);}
	inline float	GetEmitterMinAccelerationX(void)		{return m_MinAcceleration.GetX();}
	inline void		SetEmitterMinAccelerationY(float MinAcceleration)	{m_MinAcceleration.SetY(MinAcceleration);}
	inline float	GetEmitterMinAccelerationY(void)		{return m_MinAcceleration.GetY();}
	inline void		SetEmitterMinAccelerationZ(float MinAcceleration)	{m_MinAcceleration.SetZ(MinAcceleration);}
	inline float	GetEmitterMinAccelerationZ(void)		{return m_MinAcceleration.GetZ();}
	//-------------------------------------------------------
	inline void		SetEmitterMaxVelocityX(float MaxVelocity)	{m_MaxVelocity.SetX(MaxVelocity);}
	inline float	GetEmitterMaxVelocityX(void)		{return m_MaxVelocity.GetX();}
	inline void		SetEmitterMaxVelocityY(float MaxVelocity)	{m_MaxVelocity.SetY(MaxVelocity);}
	inline float	GetEmitterMaxVelocityY(void)		{return m_MaxVelocity.GetY();}
	inline void		SetEmitterMaxVelocityZ(float MaxVelocity)	{m_MaxVelocity.SetZ(MaxVelocity);}
	inline float	GetEmitterMaxVelocityZ(void)		{return m_MaxVelocity.GetZ();}

	inline void		SetEmitterMinVelocityX(float MinVelocity)	{m_MinVelocity.SetX(MinVelocity);}
	inline float	GetEmitterMinVelocityX(void)		{return m_MinVelocity.GetX();}
	inline void		SetEmitterMinVelocityY(float MinVelocity)	{m_MinVelocity.SetY(MinVelocity);}
	inline float	GetEmitterMinVelocityY(void)		{return m_MinVelocity.GetY();}
	inline void		SetEmitterMinVelocityZ(float MinVelocity)	{m_MinVelocity.SetZ(MinVelocity);}
	inline float	GetEmitterMinVelocityZ(void)		{return m_MinVelocity.GetZ();}
	//-------------------------------------------------------
};
//------------------------------------------------------------------------
#endif // __EXSYSTEMEPARTICULE_H__

