/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCImageLoader.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/ 

#ifndef __EXCIMAGELOADER__
#define __EXCIMAGELOADER__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "Math/ExMath.h"
#include "ExNihiloExecption.h"
#include "ExNihiloNameSpace.h"
//--------------------------------
#include <ddraw.h>
//--------------------------------
// Define type
//--------------------------------
#define TGA_RGB		 2		// Normal RGB file
#define TGA_A		 3		// ALPHA file
#define TGA_RLE		10		// Run-Length Encoded (RLE) file
//-------------------------------
enum TextureType
{
	BMP,TGA,PCX,JPG,RGB,RAW,PPM,DDS,UNKNOWN
};

//-------------------------------
class ExCImageLoader
{
private:
	//--------------------------------
	// Header 
	//--------------------------------
	typedef struct
	{
		unsigned char manufacturer;
		unsigned char version;
		unsigned char encoding;
		unsigned char bits;
		unsigned char xMin;
		unsigned char yMin;
		unsigned char xMax;
		unsigned char yMax;
		unsigned char *palette;
	} PCXHEADER;

	typedef struct tagBITMAPINFOHEADER{
		DWORD      biSize;
		LONG       biWidth;
		LONG       biHeight;
		WORD       biPlanes;
		WORD       biBitCount;
		DWORD      biCompression;
		DWORD      biSizeImage;
		LONG       biXPelsPerMeter;
		LONG       biYPelsPerMeter;
		DWORD      biClrUsed;
		DWORD      biClrImportant;
	} BITMAPINFOHEADER;


//--------------------------------
// Methode
//--------------------------------
	unsigned char *LoadPCXFile(std::string filename, PCXHEADER *pcxHeader);
	//void DecodeJPG(jpeg_decompress_struct* cinfo, tImage *pImageData);
	TextureType FindTextureType(std::string FileName);
public:
//--------------------------------
// Variable
//--------------------------------
	TextureType		m_TextureType;
	int				m_channels;			// The channels in the image (3 = RGB : 4 = RGBA)
	int				m_sizeX;				// The width of the image in pixels
	int				m_sizeY;				// The height of the image in pixels
	long int		m_scaledWidth;
	long int		m_scaledHeight;
	unsigned int	m_type;		// RGB,RGBA...
	unsigned char	*m_data;	// The image pixel data
	unsigned char	*m_palette;
	

	int				m_ddsBufsize;
	int				m_ddsNumMipmaps;
	int				m_ddsFormat;
	int				m_ddsComponent;
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCImageLoader(void);
	ExCImageLoader(std::string FileName);
	~ExCImageLoader(void);
//--------------------------------
// Methode
//--------------------------------
	bool LoadImage(std::string FileName);
	//bool LoadImage(const char *strFileName);
	bool LoadBMP(const char *strFileName);

	bool LoadBMP(std::string strFileName);
	bool LoadTGA(std::string strFileName);
	bool LoadJPG(std::string strFileName);
	bool LoadPCX(std::string strFileName);
	bool LoadRAW(std::string strFileName);
	bool LoadRGB(std::string strFileName);
	bool LoadPPM(std::string strFileName);
	bool LoadDDS(std::string strFileName);

	bool SaveImage(std::string FileName,int width,int height);

	bool SaveBMP(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SaveTGA(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SaveJPG(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SavePCX(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SaveRAW(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SaveRGB(std::string strFileName,int width,int height,unsigned char * ImageData);
	bool SavePPM(std::string strFileName,int width,int height,unsigned char * ImageData);
};

#endif //__EXCIMAGELOADER__











