/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCModelLoader.h										*/
/*																		*/
/* Star Date   :26/02/2003												*/
/*																		*/
/* Last Update :26/02/2003                                              */
/*                                                                      */
/* Description :This class will be used to convert model from different */
/*              format into EXM model                                   */
/************************************************************************/
#ifndef __EXCMODELLOADER__
#define __EXCMODELLOADER__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "Math/ExMath.h"
#include "ExNihiloExecption.h"
#include "Object/Object3D/Model/ExCModelEXM.h"
//-------------------------------
class ExCModelLoader
{
private:
//--------------------------------
// Variable
//--------------------------------
	void LoadMD2(std::string strFileName);
	void LoadMD3(std::string strFileName);
	void LoadASC(std::string strFileName);
	void Load3DS(std::string strFileName);
	void LoadOBJ(std::string strFileName);
	void LoadASE(std::string strFileName);
	void LoadEXM(std::string strFileName);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCModelLoader(void);
	ExCModelLoader(std::string FileName);
	~ExCModelLoader(void);
//--------------------------------
// Methode
//--------------------------------
	std::vector<ExCModelEXM>	m_VecExcModel;
	int LoadModel(std::string FileName);
};
//---------------------------------------------------
//#define for md2 model
//---------------------------------------------------
//--------------------------------
// These are the needed defines for the max values when loading .MD2 files
#define MD2_MAX_TRIANGLES		4096
#define MD2_MAX_VERTICES		2048
#define MD2_MAX_TEXCOORDS		2048
#define MD2_MAX_FRAMES			512
#define MD2_MAX_SKINS			32
#define MD2_MAX_FRAMESIZE		(MD2_MAX_VERTICES * 4 + 128)

// This holds the header information that is read in at the beginning of the file
typedef struct
{
   int ident;		 // identifies as MD2 file "IDP2"
   int version;	 // mine is 8
   int skinwidth;    // width of texture
   int skinheight;   // height of texture
   int framesize;    // number of bytes per frame
   int numSkins;     // number of textures
   int numXYZ;       // number of points
   int numST;        // number of texture
   int numTris;      // number of triangles
   int numGLcmds;
   int numFrames;    // total number of frames
   int offsetSkins;  // offset to skin names (64 bytes each)
   int offsetST;     // offset of texture s-t values
   int offsetTris;   // offset of triangle mesh
   int offsetFrames; // offset of frame data (points)
   int offsetGLcmds; // type of OpenGL commands to use
   int offsetEnd;    // end of file
} MD2_modelHeader_t;
// This stores the frames vertices after they have been transformed
// info for a single frame point
typedef struct
{
   short s;
   short t;
} MD2_stIndex_t;

typedef struct
{
   unsigned char v[3];
   unsigned char normalIndex;	// not used
} MD2_framePoint_t;

// information for a single frame
typedef struct
{
   float scale[3];
   float translate[3];
   char name[16];
   MD2_framePoint_t fp[1];
} MD2_frame_t;
// data for a single triangle
typedef struct
{
   unsigned short meshIndex[3];		// vertex indices
   unsigned short stIndex[3];		// texture coordinate indices
} MD2_mesh_t;
//---------------------------------------------------------


#endif //__EXCMODELLOADER__











