/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExDefine.h,v 1.25 2002/08/06 16:52:58 binny Exp $
 *
 */

#ifndef __EXDEFINE_H__
#define __EXDEFINE_H__

//------------------------------------------------------------------------
//lib to link
//------------------------------------------------------------------------

#ifndef UNIX_SRC
	#pragma comment(lib, "opengl32.lib")
	#pragma comment(lib, "glu32.lib")
	#pragma comment(lib, "glaux.lib")
	#pragma comment(lib, "dxerr8.lib")
	#pragma comment(lib, "winmm.lib")
	#pragma comment(lib, "dsound.lib")
	#pragma comment(lib, "dxguid.lib")
	#pragma comment(lib, "ALut.lib")
	#pragma comment(lib, "ALu.lib")
	#pragma comment(lib, "ALc.lib")
	#pragma comment(lib, "OpenAL32.lib")
#endif

#ifndef VERSION
	#define VERSION	"0.2"
#endif

#ifndef PREFIX
	#define PREFIX "/usr/local/share"
#endif

//------------------------------------------------------------------------
// Includes OpenGL
//------------------------------------------------------------------------
#include <GL/glut.h>	//Header Glut Library
#include <GL/gl.h>		//Header OpenGl
#include <GL/glu.h>		//Header Glu toolkit OpenGl
#include <GL/glext.h>
#ifndef UNIX_SRC
	#include <GL/glaux.h>	//header Glaux Library
	#include <GL/wglext.h>
#endif
#ifdef UNIX_SRC
	//#include <GL/glxext.h>	
#endif
//------------------------------------------------------------------------
// opengl extensions
//------------------------------------------------------------------------
extern PFNGLLOCKARRAYSEXTPROC glLockArraysEXT;
extern PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT;
//------------------------------------------------------------------------
// Includes OpenAL
//------------------------------------------------------------------------
#include <AL/al.h>
#include <AL/alc.h>
//------------------------------------------------------------------------
// Includes C++ 
//------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <ostream>
#include <string.h>
#include <time.h>
#include <iostream>
#include <strstream>

//------------------------------------------------------------------------
// Includes STL
//------------------------------------------------------------------------
#include <string>
#include <algorithm>
#include <vector>
#include <list>
#include <stack>

#ifndef UNIX_SRC
	#define PI							3.1415926535897932384626433832795
#else
	#include <math.h>
	#define PI M_PI
#endif

//------------------------------------------------------------------------
// Define for render type
//------------------------------------------------------------------------
#define RENDER_TEXTURES_LIGHT		10001
#define RENDER_TEXTURES				10002
#define RENDER_TRIANGLES_LIGHT	    10003
#define RENDER_TRIANGLES			10005
#define RENDER_POINTS				10006
#define RENDER_LINES				10007
#define RENDER_NO					10008
//------------------------------------------------------------------------
// typedef
//------------------------------------------------------------------------
typedef long ExId;
typedef std::pair<ExId,char *> IdName;
typedef unsigned int uint;
typedef unsigned char uchar;
//------------------------------------------------------------------------
// consol redirection
//------------------------------------------------------------------------
//#define CLEARCONSOL	std::ofstream Consol("Consol.log",std::ios::out);Consol.close();

//static std::ofstream Consol("Consol.log",std::ios::app);

extern std::ostrstream *Consol;
#define CLEARCONSOL Consol.flush();
/*
	DEBUG TOOLS ARE IN ExCTrace.[cpp|h] NOW !!!
*/
#include "ExCTrace.h"

#endif //_EXDEFINE_H__


