/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCam.h,v 1.5 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERCAM_H__
#define __EXMANAGERCAM_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCCamera.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
#include "ExManagerId.h"
//--------------------------------
class ExManagerCam 
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
	ExManagerId						*ManagerId	;

	std::vector<ExCCamera> m_VecCamera;
	std::vector<ExCCamera>::iterator m_ItVecCamera;

	ExId m_CurrentCam;
	
	ExId						m_MultSlot1;
	ExId						m_MultSlot2;
	ExId						m_MultSlot3;
	ExId						m_MultSlot4;
	int							itcount;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerCam(void);
	~ExManagerCam(void);
//--------------------------------
// Methode
//--------------------------------
	bool					m_multiview;
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	ExCCamera * GetCurrentCam(void);
	void NextCam(void);
	void PrevCam(void);
	void SetCurrentCam(ExId Id);
	void Draw(int x,int y);
	void Reset(void);
	void Init(void);
	bool Init(char * FileName);
	ExId NewObject(void);
	ExCCamera *  Get(char * Name);
	ExCCamera *  Get(ExId Id);
	ExId Add(ExCCamera Object);
	bool Remove(ExId Id);
	ExId GetIdByName(char *Name);
	char * GetNameById(ExId Id);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERCAM_H__
