/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCommand.h,v 1.9 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERCOMMAND_H__
#define __EXMANAGERCOMMAND_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerMap.h"
#include "ExManagerFog.h"
#include "ExManagerAnimation.h"
#include "ExManagerWindow.h"
#include "ExManagerEntite.h"
#include "ExManagerGizmo.h"
#include "ExManagerLight.h"
#include "ExManagerCam.h"
#include "ExManagerParticuleSystem.h"
#include "ExManagerTexture.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
#include "ExManagerId.h"
#include "ExManagerMenu.h"
#include "ExManagerInterface.h"
#include "ExManagerConsole.h"
#include "ExManagerSound.h"
#include "ExManagerSpirit.h"
#include "InputActionList.h"
#include "ExCFile.h"
//--------------------------------
class ExManagerCommand
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerMenu				*ManagerMenu;
	ExManagerMap				*ManagerMap;	
	ExManagerFog				*ManagerFog;
	ExManagerAnimation			*ManagerAnim;
	ExManagerWindow				*ManagerWindow;
	ExManagerEntite				*ManagerEntite;
	ExManagerGizmo				*ManagerGizmo;
	ExManagerLight				*ManagerLight;
	ExManagerCam				*ManagerCam;
	ExManagerParticuleSystem	*ManagerParticuleSystem;
	ExManagerTexture			*ManagerTexture;
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
	ExManagerId					*ManagerId	;
	ExManagerInterface			*ManagerInterface;
	ExManagerConsole			*ManagerConsole;
	ExManagerSpirit				*ManagerSpirit;
	ExManagerSound				*ManagerSound;

	int		m_MousePosX;
	int		m_MousePosY;	

	typedef std::pair<int,SAction> CommandAction;
	std::vector<CommandAction>				m_VecCommand;
	std::vector<CommandAction>::iterator	m_ItVecCommand;

	std::vector<SAction>			m_VecAction;
	std::vector<SAction>::iterator	m_ItVecAction;
	std::vector<SAction>			m_VecTempAction;//action added when action run

	std::vector<SAction>			m_VecRepAction;
	std::vector<SAction>::iterator	m_ItVecRepAction;

	void RemoveRepAction(SAction action);
	void AddRepAction(SAction action);
	void AddAction(SAction action);
	void AddCommandAction (ExCFileDataAction);
	void AddCommandAction(int command,SAction action);
	void AddCommandAction(int command,int action,char *param);
	void AddCommandAction(CommandAction ComAct); 
	void ProcessCommand(int command);
	bool ProcessAction(SAction action);

	bool LogCommand;
	ofstream logfilecommand;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerCommand(void);
	~ExManagerCommand(void);
//--------------------------------
// Methode
//--------------------------------
	void AddNewAction(SAction action);
	void Reset(void);
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerFog(ExManagerFog *Fog){ManagerFog = Fog;}
	inline void SetManagerAnim(ExManagerAnimation *Anim){ManagerAnim = Anim;}
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerEntite(ExManagerEntite *Entite){ManagerEntite = Entite;}
	inline void SetManagerGizmo(ExManagerGizmo *Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerLight(ExManagerLight *Light){ManagerLight = Light;}
	inline void SetManagerCam(ExManagerCam *Cam){ManagerCam = Cam;}
	inline void SetManagerParticuleSystem(ExManagerParticuleSystem *ParticuleSystem){ManagerParticuleSystem = ParticuleSystem;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	inline void SetManagerMenu(ExManagerMenu * Menu){ManagerMenu=Menu;}
	inline void SetManagerInterface(ExManagerInterface * Interface){ManagerInterface=Interface;}
	inline void SetManagerConsole(ExManagerConsole * Console){ManagerConsole=Console;}
	inline void SetManagerSound(ExManagerSound * Sound){ManagerSound=Sound;}
	inline void SetManagerSpirit(ExManagerSpirit * Spirit){ManagerSpirit=Spirit;}

	void Init(void);
	bool LoadCommandFile(const char *FileName);
	bool LoadExecFile(SAction *action);
	bool LoadFile(const char *FileName);

	void InputCommand(int command);
	void ApplyAction(void);

	inline void SetMousePosition(int posx,int posy){m_MousePosX=posx;m_MousePosY=posy;}
	void LoadSetOfFile(const char *FileName);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERCOMMAND_H__
