/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerConsole.h,v 1.12 2002/08/02 18:55:14 data Exp $
 *
 */

#ifndef __EXMANAGERCONSOLE_H__
#define __EXMANAGERCONSOLE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "InputActionList.h"
#include "ExManagerWindow.h"
#include "ExManagerTexture.h"
#include "ExPredefinedObject.h"
#include "ExCFile.h"

#include <stdarg.h>

#define HIDE		0
#define HALF		1
#define FULL		2
#define HIDETOHALF	3
#define HIDETOFULL  4
#define HALFTOFULL	5
#define FULLTOHALF	6
#define FULLTOHIDE	7
#define HALFTOHIDE	8

#define PREDIFINEDCOMMAND 10
//--------------------------------
class ExManagerConsole
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerWindow			*ManagerWindow;
	ExManagerTexture		*ManagerTexture;
	int						m_ConsoleState;	//HIDE,HALF,FULL
 	int						m_LineCounter;
 	int						m_ConsoleTrans;
	int						m_NextConsoleState;
	int						m_ConsoleTransPalier;
	bool					console_move;

	char					*m_BackGroundTexture;
	
	std::string									m_BuffCommand;
	std::vector<std::string>					m_BuffOldCommand;

	int PosIntoBuffOldCommand;

	typedef std::pair<std::string,int>			StringAction;
    std::vector<StringAction>					m_VecStringAction;
	std::vector<StringAction>::iterator			m_ItVecStringAction;

   	std::vector<std::string>						m_BufferConsol;
	std::vector<std::string>::reverse_iterator		m_RItBufferConsol;
	std::vector<std::string>::iterator				m_ItBufferConsol;

	ofstream logfilecsl;
	
	bool					LogConsol;
	bool					m_BackGroundTextureState;
	bool					m_Blending;
	float                   m_fBlending;
	float                   m_fBackGroundBlue;
	float                   m_fBackGroundRed;
	float                   m_fBackGroundGreen;
	int						m_LineToStar;
	int						m_LineInConsol;
//--------------------------------
// Methode
//--------------------------------	
	void AddStringAction(const char *String,int Action);
	void AddStringAction(StringAction StrAction);
	void AddStringAction(ExCFileDataAction);
	SAction ApplyBuffCommand(void);
	void WriteInDaFile (std::string str);

	
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerConsole(void);
	~ExManagerConsole(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);
	
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerTexture(ExManagerTexture *Texture){ManagerTexture = Texture;}

	void ClearConsol(void);
	void Reset(void);
	void Write (const char *);
	//void Write (const char *, ...);
	//void Write (std::string);
	void Init(void);
	int NextAviableState(void);
	void SetConsoleState(int state);
	int GetConsoleState (void) { return m_ConsoleState; }
	void ConsoleMove (bool);
	bool isConsoleMove (void) { return console_move; }
	void SetConsoleBackGroudTexture(const char *FileName);
	inline void SetConsoleBackGroudTextureState(bool state){m_BackGroundTextureState=state;}
	inline void SetConsoleBackGroudBlendingState(bool state){m_Blending=state;}
	inline void SetConsoleBackGroudBlending(float blending){m_fBlending=blending;}
	inline void SetConsoleBackGroudColorRed(float value){m_fBackGroundRed=value;}
	inline void SetConsoleBackGroudColorGreen(float value){m_fBackGroundGreen=value;}
	inline void SetConsoleBackGroudColorBlue(float value){m_fBackGroundBlue=value;}
	inline void SetConsoleBackGroudColor(float R,float G,float B ){m_fBackGroundBlue=B;m_fBackGroundGreen=G;m_fBackGroundRed=R;}

	void LoadStringActionFile(const char *FileName);

	void DrawConsole(void);
	SAction InputCommand(int command,int mousex,int mousey);
	void ListConsoleCommand(void);

	void LineUp(void);
	void LineDown(void);
};
#endif //__EXMANAGERCONSOLE_H__
