/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerEntite.h,v 1.8 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERENTITE_H__
#define __EXMANAGERENTITE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
//--------------------------------
#include "ExManagerTexture.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
#include "ExManagerId.h"
//--------------------------------
#include "ExCEntite.h"
#include "ExCComposed.h"
#include "ExSkeleton.h"
#include "ExCModel.h"
#include "ExCModelMD2.h"
#include "ExCModelMD3.h"
#include "ExCModelASE.h"
#include "ExCModelASC.h"
#include "ExCModel3DS.h"
#include "ExCModelOBJ.h"
//--------------------------------
class ExManagerEntite 
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerTexture			*ManagerTexture;
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
	ExManagerId					*ManagerId;
//--------------------------------
	std::vector<ExCModel *>				*m_VecPModel;
	std::vector<ExCModel *>::iterator	m_ItVecPModel;
	std::vector<ExCModelMD2>			m_VecModelMD2;
	std::vector<ExCModelMD2>::iterator	m_ItVecModelMD2;
	std::vector<ExCModelMD3>			m_VecModelMD3;
	std::vector<ExCModelMD3>::iterator	m_ItVecModelMD3;
	std::vector<ExCModelASE>			m_VecModelASE;
	std::vector<ExCModelASE>::iterator	m_ItVecModelASE;
	std::vector<ExCModelASC>			m_VecModelASC;
	std::vector<ExCModelASC>::iterator	m_ItVecModelASC;
	std::vector<ExCModel3DS>			m_VecModel3DS;
	std::vector<ExCModel3DS>::iterator	m_ItVecModel3DS;
	std::vector<ExCModelOBJ>			m_VecModelOBJ;
	std::vector<ExCModelOBJ>::iterator	m_ItVecModelOBJ;
//--------------------------------
	std::vector<ExCEntite *> *m_VecPObject;
	std::vector<ExCEntite *>::iterator m_ItVecPObject;

	std::vector<ExCEntite> *m_VecEntite;
	std::vector<ExCEntite>::iterator m_ItVecEntite;

	std::vector<ExCComposed> *m_VecComposed;
	std::vector<ExCComposed>::iterator m_ItVecComposed;

	std::vector<ExSkeleton> *m_VecSkeleton;
	std::vector<ExSkeleton>::iterator m_ItVecSkeleton;
	
	ExId m_CurrentEntite;

	void CreateVecPobject(void);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerEntite(void);
	~ExManagerEntite(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
//--------------------------------
	bool LoadModel(const char * FileName);

//--------------------------------
	ExCEntite * GetCurrentEntite(void);
	void NextEntite(void);
	void PrevEntite(void);
	bool SetCurrentEntite(ExId Id);
	
	void Reset(void);
	void Init(void);
	bool Init(char * FileName);
	ExId NewObject(void);
	ExCEntite * Get(char * Name);
	ExCEntite * Get(ExId Id);
	ExId Add(ExCEntite Object);
	ExId Add(ExCComposed Object);
	ExId Add(ExSkeleton Object);
	bool Remove(ExId Id);
    	
	void MakeGlListForAll(void);
	void LoadAsc(const char *FileName);
	
	bool SetCurrentEntiteName(const char *Name);

	void ListEntite(void);

	int GetNumberEntite(void){return m_VecPObject->size();}

	inline void RecordToManagerPVS(void){ManagerPVS->SetVecEntite(m_VecPObject);}
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
	
};
#endif //__EXMANAGERENTITE_H__
