/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerFog.h,v 1.5 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERFOG_H__
#define __EXMANAGERFOG_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerId.h"
//--------------------------------
class ExManagerFog
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerId						*ManagerId	;
	GLfloat m_FogColor[4];
	GLfloat m_StartPoint;
	GLfloat m_EndPoint;
	GLfloat m_Density;
	GLenum	m_FogAlgo;
	bool m_State;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerFog(void);
	~ExManagerFog(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}

	void Reset(void);

	void EnableFog(void);
	void DisableFog(void);
	inline bool GetState(void){return m_State;}

	void  SetFogColor(float R,float G,float B,float A);
	inline void SetFogColorR(float R);
	inline float GetFogColorR(void){return m_FogColor[0];}
	void  IncFogColorR(float inc);
	void  SetFogColorG(float G);
	inline float GetFogColorG(void){return m_FogColor[1];}
	void  IncFogColorG(float inc);
	void  SetFogColorB(float B);
	inline float GetFogColorB(void){return m_FogColor[2];}
	void  IncFogColorB(float inc);
	void  SetFogColorA(float A);
	inline float GetFogColorA(void){return m_FogColor[3];}
	void  IncFogColorA(float inc);

	void  SetStartPoint(float P);
	inline float GetStarPoint(void){return m_StartPoint;}
	void  IncStartPoint(float inc);
	
	void  SetEndPoint(float P);
	inline float GetEndPoint(void){return m_EndPoint;}
	void  IncEndPoint(float inc);

	void  SetDensity(float P);
	inline float GetDensity(void){return m_Density;}
	void  IncDensity(float inc);

	inline GLenum GetAlgo(void){return m_FogAlgo;}
	void SetAlgo(GLenum algo);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERFOG_H__
