/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerId.h,v 1.6 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef _EXMANAGERID_H__
#define _EXMANAGERID_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
//--------------------------------
class ExManagerId  
{
private:
//--------------------------------
// Variable
//--------------------------------
	int m_ExIdCounter;

	std::vector<IdName> m_VecObject;
	std::vector<IdName>::iterator m_ItVecObject;

	char * GetAviableName(const char *Name,int occu);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerId();
	~ExManagerId();
//--------------------------------
// Methode
//--------------------------------
	void Reset(void);
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	IdName GetNewIdName(char * Name);
	ExId GetObjectIdByName(char * Name);
	char * GetObjectNameById(ExId Id);

	bool RemoveIdName(char * Name);
	bool RemoveIdName(ExId Id);
	bool isNameAviable(char * Name);
	bool RecordIdName(ExId Id,char * Name);
	bool RecordIdName(IdName idname);
};

#endif // _EXMANAGERID_H__
