/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerLight.h,v 1.5 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERLIGHT_H__
#define __EXMANAGERLIGHT_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCLight.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
#include "ExManagerId.h"
//--------------------------------
class ExManagerLight 
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
	ExManagerId						*ManagerId	;
	
	std::vector<ExCLight> m_VecLight;
	std::vector<ExCLight>::iterator m_ItVecLight;

	void RegisterToPVS(ExId Id);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerLight(void);
	~ExManagerLight(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}

	void Reset(void);
	void Init(void);
	bool Init(char * FileName);
	ExId NewObject(void);
	ExCLight * Get(char * Name);
	ExCLight * Get(ExId Id);
	ExId Add(ExCLight Object);
	bool Remove(ExId Id);
	ExId GetIdByName(char *Name);
	char * GetNameById(ExId Id);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERLIGHT_H__
