/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerMap.h,v 1.5 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERMAP_H__
#define __EXMANAGERMAP_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCMap.h"
#include "ExManagerTexture.h"
#include "ExManagerId.h"

//--------------------------------
class ExManagerMap
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerId					*ManagerId;
	ExManagerTexture			*ManagerTexture;
	ExCMap						*Map;
	bool						MapLoaded;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerMap(void);
	~ExManagerMap(void);
//--------------------------------
// Methode
//--------------------------------
	void Reset(void);
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}

	void LoadMap(const char * FileName);
	void Draw(void);
	inline void ShowSkybox(void){Map->ShowSkybox();}
	inline void HideSkybox(void){Map->HideSkybox();}
	inline void ShowMesh(void){Map->ShowMesh();}
	inline void HideMesh(void){Map->HideMesh();}
	inline void EnableOctree(void){Map->EnableOctree();}
	inline void DisableOctree(void){Map->DisableOctree();}
	inline void ShowOctreeSubdivision(void){Map->ShowOctreeSubdivision();}
	inline void HideOctreeSubdivision(void){Map->HideOctreeSubdivision();}
};
#endif //__EXMANAGERMAP_H__
