/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerObject.h,v 1.4 2002/06/16 00:51:03 binny Exp $
 *
 */

#ifndef __EXMANAGEROBJECT_H__
#define __EXMANAGEROBJECT_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
//--------------------------------
template <class TypeA>
class ExManagerObject
{
protected:
//--------------------------------
// Variable
//--------------------------------
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
//--------------------------------
//Using vector 
//--------------------------------
	std::vector<TypeA> m_Vec;
	typename std::vector<TypeA>::iterator m_ItVec;
public :
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerObject();
	~ExManagerObject();
//--------------------------------
// Methode
//--------------------------------
	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	void Reset(void);
};

template<class TypeA>
ExManagerObject<TypeA>::ExManagerObject(void)
{
Guard(ExManagerObject<TypeA>::ExManagerObject(void))
UnGuard
}

template<class TypeA>
ExManagerObject<TypeA>::~ExManagerObject(void)
{
Guard(ExManagerObject<TypeA>::~ExManagerObject(void))
UnGuard
}

template<class TypeA>
void  ExManagerObject<TypeA>::Reset(void)
{
Guard(void  ExManagerObject<TypeA>::Reset(void))
	m_Vec.clear();
UnGuard
}



#endif //__EXMANAGEROBJECT_H__
