/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerOutput.h,v 1.11 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGEROUTPUT_H__
#define __EXMANAGEROUTPUT_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerWindow.h"
#include "ExManagerAnimation.h"
#include "ExManagerCollision.h"
#include "ExManagerPVS.h"
#include "ExManagerFog.h"
#include "ExManagerCam.h"
#include "ExManagerMap.h"
#include "ExManagerCommand.h"
#include "ExManagerConsole.h"
#include "ExManagerMenu.h"
#include "ExManagerInterface.h"
#include "ExPredefinedObject.h"
//--------------------------------
class ExManagerOutput
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
	ExManagerFog				*ManagerFog;
	ExManagerAnimation			*ManagerAnim;
	ExManagerWindow				*ManagerWindow;
	ExManagerCam				*ManagerCam;
	ExManagerCommand			*ManagerCommand;
	ExManagerInterface			*ManagerInterface;
	ExManagerMenu				*ManagerMenu;
	ExManagerConsole			*ManagerConsole;
	ExManagerMap				*ManagerMap;

	
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerOutput(void);
	~ExManagerOutput(void);
//--------------------------------
// Methode
//--------------------------------
	void Reset(void);
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerFog(ExManagerFog *Fog){ManagerFog = Fog;}
	inline void SetManagerAnim(ExManagerAnimation *Anim){ManagerAnim = Anim;}
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerCam(ExManagerCam *Cam){ManagerCam = Cam;}
	inline void SetManagerCommand(ExManagerCommand *Command){ManagerCommand	= Command;}
	inline void SetManagerInterface(ExManagerInterface * Interface){ManagerInterface=Interface;}
	inline void SetManagerConsole(ExManagerConsole * Console){ManagerConsole=Console;}
	inline void SetManagerMenu(ExManagerMenu * Menu){ManagerMenu=Menu;}

	void DrawScene(void);
	void Reshape(int w,int h);
	void Init(void);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGEROUTPUT_H__
