/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerPVS.h,v 1.8 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERPVS_H__
#define __EXMANAGERPVS_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCFrustum.h"
#include "ExCObject.h"
#include "ExCEntite.h"
#include "ExCComposed.h"
#include "ExCGizmo.h"
#include "ExCGizmoFace.h"
#include "ExCGizmoLine.h"
#include "ExCGizmoPoint.h"
#include "ExCGizmoRectangle.h"
#include "ExCParticule.h"
#include "ExCSystemeParticule.h"
#include "ExSkeleton.h"
#include "ExManagerId.h"
//--------------------------------
#include "ExCModel.h"
#include "ExCModelMD2.h"
#include "ExCModelMD3.h"
#include "ExCModelASE.h"
#include "ExCModelASC.h"
#include "ExCModel3DS.h"
#include "ExCModelOBJ.h"
//--------------------------------
class ExManagerPVS
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerId				*ManagerId	;
	ExCFrustum				Frustrum;

	std::vector<ExCEntite *> *m_VecEntite;
	std::vector<ExCEntite *>::iterator m_ItVecEntite;

		
	std::vector<ExCSystemeParticule *> *m_VecSystemeParticule;
	
	std::vector<ExCModel *>				*m_VecPModel;
	std::vector<ExCModel *>::iterator	m_ItVecPModel;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerPVS(void);
	~ExManagerPVS(void);
//--------------------------------
// Methode
//--------------------------------
	void Reset(void);
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}

	void DrawObjectInPVS(void);
	void DrawAllObject(void);
	inline void SetVecEntite(std::vector<ExCEntite *> * vec){m_VecEntite=vec;}
	inline void SetVecSystemeParticule(std::vector<ExCSystemeParticule*> * vec){m_VecSystemeParticule=vec;}
};
#endif //__EXMANAGERPVS_H__
