/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerParticuleSystem.h,v 1.7 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERPARTICULESYSTEM_H__
#define __EXMANAGERPARTICULESYSTEM_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerTexture.h"
#include "ExCSystemeParticule.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"

//--------------------------------
class ExManagerParticuleSystem 
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerTexture			*ManagerTexture;
	ExManagerPVS				*ManagerPVS;
	ExManagerCollision			*ManagerCollision;
		
	std::vector<ExCSystemeParticule> *m_VecParticuleSysteme;
	std::vector<ExCSystemeParticule*> *m_VecPParticuleSysteme;
	std::vector<ExCSystemeParticule>::iterator m_ItVecParticuleSysteme;

	void CreateVecPobject(void);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerParticuleSystem(void);
	~ExManagerParticuleSystem(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerPVS(ExManagerPVS * PVS){ManagerPVS = PVS;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}

	bool LoadParticuleSysteme(const char * FileName);
	
	int StartParticuleSysteme(char *param);
	int StopParticuleSysteme(char *param);
	int PauseParticuleSysteme(char *param);

	int StartAllParticuleSysteme(void);
	int StopAllParticuleSysteme(void);
	int PauseAllParticuleSysteme(void);

	inline int GetNumberEnableParticuleSysteme(void){return m_VecParticuleSysteme->size();}
	void ListParticuleSysteme(void);
	inline void RecordToManagerPVS(void){ManagerPVS->SetVecSystemeParticule(m_VecPParticuleSysteme);}
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERPARTICULESYSTEM_H__
