/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerSound.h,v 1.8 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERSOUND_H__
#define __EXMANAGERSOUND_H__

#include "ExDefine.h"
#include "ExMath.h"
#include "ExCSound.h"
#include "ExManagerId.h"

#define MAX_SOUND 20

class ExManagerSound {
	private:
		ExManagerId *ManagerId;
		ALCcontext *context_id;
		ALCdevice *dev;
		
	public:
		ExManagerSound (void);
		~ExManagerSound (void);
		std::ostrstream *Consol;
		void (*WriteToConsol)(const char *Label);
	
		inline void SetManagerId (ExManagerId *Id) { ManagerId	= Id; }
		bool Init (void);
		
		void DisplayAviableInput (void);
		
		void ListAllSound (void);
		bool LoadSound (std::string);
		bool RemoveSound (std::string);
		void PlaySound (std::string);
		void StopSound (std::string);
		int GetSound (std::string);
		void Reset (void);
};
#endif //__EXMANAGERSOUND_H__
