/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerTexture.h,v 1.10 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMANAGERTEXTURE_H__
#define __EXMANAGERTEXTURE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCTexture.h"
#include "ExManagerId.h"
#include "ExCImage.h"
//--------------------------------
class ExManagerTexture 
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerId						*ManagerId	;

	std::vector<ExCTexture> m_VecTextures;
	std::vector<ExCTexture>::iterator m_ItVecTextures;
	int m_CouterTextures;

	struct Image {
		unsigned long sizeX;
		unsigned long sizeY;
		char *data;
        };
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerTexture(void);
	~ExManagerTexture(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}

	void Reset(void);
	void Init(void);
	bool Init(char * FileName);

	bool CheckExist(const char * name);
	bool AddTexture(const char * name);

	GLuint GetTexture(char * name);
    bool SetActiveTexture(char * name);
	void ListAllTexture(void);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERTEXTURE_H__
