/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerWindow.h,v 1.11 2002/08/06 16:52:58 binny Exp $
 *
 */

#ifndef __EXMANAGERWINDOW_H__
#define __EXMANAGERWINDOW_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerId.h"
#include "ExPredefinedObject.h"
#include "ExCOptions.h"

//--------------------------------
#define NON_EFFECT			0
#define FADE_TO_WHITE		1
#define WITHE_TO_FADE		2
#define FADE_TO_BLACK		3
#define BLACK_TO_FADE       4
//--------------------------------
class ExManagerWindow
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerId		*ManagerId;
	ExCOptions      *options;

	int m_WindowHandler;
	int m_WindowSizeX;
	int m_WindowSizeY;
	int m_WindowSizeXOld;
	int m_WindowSizeYOld;
	int m_WindowPosX;
	int m_WindowPosY;
	int m_Bits;
	int m_Rate;
	bool m_FullScreen;
	bool m_OldMode;
	char *m_Title;
	char *m_IconTitle;
	int m_Cursor;

	bool m_ShowFps;
	bool m_ShowGrille;
	bool m_ShowNetStat;
	bool m_Antialliasing;
	bool m_Menu;
	bool m_Console;
	bool m_Interface;
	bool m_MotionBlur;
	bool m_MotionBlurTexture;
	uint TextureMotionBlur;
	
	int frame,timeframe,timebase;
	char s[30];
	
	int	m_effect;
	float m_CouterEffect;

public:
	void (*GlutCallBack)();
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExManagerWindow(void);
	~ExManagerWindow(void);
//--------------------------------
// Methode
//--------------------------------
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	
	void Create(int SizeX,int SizeY,int PosX,int PosY,char *argv);
	void Create(int SizeX,int SizeY,char *argv);
	void Move(int Posx,int Posy);
	void SetResolution(int SizeX,int SizeY);
	inline void SetRate(int Rate){m_Rate=Rate;}
	inline void SetBits(int Bits){m_Bits=Bits;}
	inline void SetFullScreen(bool State){m_FullScreen=State;}
	void SetWindowTitle(char *Title);
	void SetIconTitle(char *Title);
	void SetCursor(int Cursor);
	void Apply(void);

	inline int GetResolutionX(void){return m_WindowSizeX;}
	inline int GetResolutionY(void){return m_WindowSizeY;}
	inline int GetRate(void){return m_Rate;}
	inline int GetBits(void){return m_Bits;}
	inline bool GetFullScreen(void){return m_FullScreen;}

	inline void SetFpsState(bool state){m_ShowFps=state;}
	inline void SetGrilleState(bool state){m_ShowGrille=state;}
	inline void SetNetstatState(bool state){m_ShowNetStat=state;}
	void SetAntialliasingState(bool state);
	inline void SetMenuState(bool state){m_Menu=state;}
	inline void SetConsoleState(bool state){m_Console=state;}
	inline void SetInterfaceState(bool state){m_Interface=state;}
	inline void SetMotionBlurState(bool state){m_MotionBlur=state;}


	inline bool GetFpsState(void){return m_ShowFps;}
	inline bool GetGrilleState(void){return m_ShowGrille;}
	inline bool GetNetstatState(void){return m_ShowNetStat;}
	inline bool GetAntialliasingState(void){return m_Antialliasing;}
	inline bool GetMenuState(void){return m_Menu;}
	inline bool GetConsoleState(void){return m_Console;}
	inline bool GetInterfaceState(void){return m_Interface;}
	inline bool GetMotionBlurState(void){return m_MotionBlur;}

	void EnterOrthoMode(int left, int top, int right, int bottom);
	void LeaveOrthoMode(void);	
	
	void ShowFps(void);
	void ShowNetStat(void);
	void MotionBlur(void);
	void CapturForMotionBlur(void);
	void Specialeffect(void);
	void Reset(void);
	void SetSpecialEffect(int effect);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXMANAGERWINDOW_H__
