/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :                                                        */
/* $Id: InputActionList.h,v 1.18 2002/08/02 18:55:14 data Exp $         */
/*																		*/
/* File Description :All key											*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __INPUTACTIONLIST_H__
#define __INPUTACTIONLIST_H__

#include "ExDefine.h"

//--------------------------------------------------------------
//First all command key mouse ,...
//--------------------------------------------------------------
#define NO_INPUT							40000

#define MOUSE_LEFT_BUTTON_UP				40001
#define MOUSE_LEFT_BUTTON_DOWN				40002
#define MOUSE_RIGHT_BUTTON_UP				40003
#define MOUSE_RIGHT_BUTTON_DOWN				40004
#define MOUSE_MIDDLE_BUTTON_UP				40005
#define MOUSE_MIDDLE_BUTTON_DOWN			40006


#define KEYBOARD_DOWN_ESC					10001
#define KEYBOARD_DOWN_F1					10002
#define KEYBOARD_DOWN_F2					10003
#define KEYBOARD_DOWN_F3					10004
#define KEYBOARD_DOWN_F4					10005
#define KEYBOARD_DOWN_F5					10006
#define KEYBOARD_DOWN_F6					10007
#define KEYBOARD_DOWN_F7					10008
#define KEYBOARD_DOWN_F8					10009
#define KEYBOARD_DOWN_F9					10010
#define KEYBOARD_DOWN_F10					10011
#define KEYBOARD_DOWN_F11					10012
#define KEYBOARD_DOWN_F12					10013
#define KEYBOARD_DOWN_EXP					10014
#define KEYBOARD_DOWN_1						10015
#define KEYBOARD_DOWN_2						10016
#define KEYBOARD_DOWN_3						10017
#define KEYBOARD_DOWN_4						10018
#define KEYBOARD_DOWN_5						10019
#define KEYBOARD_DOWN_6						10020
#define KEYBOARD_DOWN_7						10021
#define KEYBOARD_DOWN_8						10022
#define KEYBOARD_DOWN_9						10023
#define KEYBOARD_DOWN_0						10024
#define KEYBOARD_DOWN_ENTER					10025
#define KEYBOARD_DOWN_SPACE					10026
#define KEYBOARD_DOWN_RSHIFT				10027
#define KEYBOARD_DOWN_LSHIFT				10028
#define KEYBOARD_DOWN_ARROW_UP				10029
#define KEYBOARD_DOWN_ARROW_DOWN			10030
#define KEYBOARD_DOWN_ARROW_LEFT			10031
#define KEYBOARD_DOWN_ARROW_RIGHT			10032
#define KEYBOARD_DOWN_PAGE_UP				10033
#define KEYBOARD_DOWN_PAGE_DOWN				10034
#define KEYBOARD_DOWN_HOME					10035
#define KEYBOARD_DOWN_END					10036
#define KEYBOARD_DOWN_INSERT				10037
#define KEYBOARD_DOWN_A						10038
#define KEYBOARD_DOWN_Z						10039
#define KEYBOARD_DOWN_E						10040
#define KEYBOARD_DOWN_R						10041
#define KEYBOARD_DOWN_T						10042
#define KEYBOARD_DOWN_Y						10043
#define KEYBOARD_DOWN_U						10044
#define KEYBOARD_DOWN_I						10045
#define KEYBOARD_DOWN_O						10046
#define KEYBOARD_DOWN_P						10047
#define KEYBOARD_DOWN_Q						10048
#define KEYBOARD_DOWN_S						10049
#define KEYBOARD_DOWN_D						10050
#define KEYBOARD_DOWN_F						10051
#define KEYBOARD_DOWN_G						10052
#define KEYBOARD_DOWN_H						10053
#define KEYBOARD_DOWN_J						10054
#define KEYBOARD_DOWN_K						10055
#define KEYBOARD_DOWN_L						10056
#define KEYBOARD_DOWN_M						10057
#define KEYBOARD_DOWN_W						10058
#define KEYBOARD_DOWN_X						10059
#define KEYBOARD_DOWN_C						10060
#define KEYBOARD_DOWN_V						10061
#define KEYBOARD_DOWN_B						10062
#define KEYBOARD_DOWN_N						10063
#define KEYBOARD_DOWN_M_A					10064
#define KEYBOARD_DOWN_M_Z					10065
#define KEYBOARD_DOWN_M_E					10066
#define KEYBOARD_DOWN_M_R					10067
#define KEYBOARD_DOWN_M_T					10068
#define KEYBOARD_DOWN_M_Y					10069
#define KEYBOARD_DOWN_M_U					10070
#define KEYBOARD_DOWN_M_I					10071
#define KEYBOARD_DOWN_M_O					10072
#define KEYBOARD_DOWN_M_P					10073
#define KEYBOARD_DOWN_M_Q					10074
#define KEYBOARD_DOWN_M_S					10075
#define KEYBOARD_DOWN_M_D					10076
#define KEYBOARD_DOWN_M_F					10077
#define KEYBOARD_DOWN_M_G					10078
#define KEYBOARD_DOWN_M_H					10079
#define KEYBOARD_DOWN_M_J					10080
#define KEYBOARD_DOWN_M_K					10081
#define KEYBOARD_DOWN_M_L					10082
#define KEYBOARD_DOWN_M_M					10083
#define KEYBOARD_DOWN_M_W					10084
#define KEYBOARD_DOWN_M_X					10085
#define KEYBOARD_DOWN_M_C					10086
#define KEYBOARD_DOWN_M_V					10087
#define KEYBOARD_DOWN_M_B					10088
#define KEYBOARD_DOWN_M_N					10089
#define KEYBOARD_DOWN__						10090
#define KEYBOARD_DOWN_2POINTS				10091
#define KEYBOARD_DOWN_POINT 				10092
#define KEYBOARD_DOWN_BACKSPACE				10093
#define KEYBOARD_DOWN_TAB					10094
#define KEYBOARD_DOWN_CTRL_U				10095
//--------------------------------------------
#define KEYBOARD_UP_ESC						20001
#define KEYBOARD_UP_F1						20002
#define KEYBOARD_UP_F2						20003
#define KEYBOARD_UP_F3						20004
#define KEYBOARD_UP_F4						20005
#define KEYBOARD_UP_F5						20006
#define KEYBOARD_UP_F6						20007
#define KEYBOARD_UP_F7						20008
#define KEYBOARD_UP_F8						20009
#define KEYBOARD_UP_F9						20010
#define KEYBOARD_UP_F10						20011
#define KEYBOARD_UP_F11						20012
#define KEYBOARD_UP_F12						20013
#define KEYBOARD_UP_EXP						20014
#define KEYBOARD_UP_1						20015
#define KEYBOARD_UP_2						20016
#define KEYBOARD_UP_3						20017
#define KEYBOARD_UP_4						20018
#define KEYBOARD_UP_5						20019
#define KEYBOARD_UP_6						20020
#define KEYBOARD_UP_7						20021
#define KEYBOARD_UP_8						20022
#define KEYBOARD_UP_9						20023
#define KEYBOARD_UP_0						20024
#define KEYBOARD_UP_ENTER					20025
#define KEYBOARD_UP_SPACE					20026
#define KEYBOARD_UP_RSHIFT					20027
#define KEYBOARD_UP_LSHIFT					20028
#define KEYBOARD_UP_ARROW_UP				20029
#define KEYBOARD_UP_ARROW_DOWN				20030
#define KEYBOARD_UP_ARROW_LEFT				20031
#define KEYBOARD_UP_ARROW_RIGHT				20032
#define KEYBOARD_UP_PAGE_UP					20033
#define KEYBOARD_UP_PAGE_DOWN				20034
#define KEYBOARD_UP_HOME					20035
#define KEYBOARD_UP_END						20036
#define KEYBOARD_UP_INSERT					20037
#define KEYBOARD_UP_A						20038
#define KEYBOARD_UP_Z						20039
#define KEYBOARD_UP_E						20040
#define KEYBOARD_UP_R						20041
#define KEYBOARD_UP_T						20042
#define KEYBOARD_UP_Y						20043
#define KEYBOARD_UP_U						20044
#define KEYBOARD_UP_I						20045
#define KEYBOARD_UP_O						20046
#define KEYBOARD_UP_P						20047
#define KEYBOARD_UP_Q						20048
#define KEYBOARD_UP_S						20049
#define KEYBOARD_UP_D						20050
#define KEYBOARD_UP_F						20051
#define KEYBOARD_UP_G						20052
#define KEYBOARD_UP_H						20053
#define KEYBOARD_UP_J						20054
#define KEYBOARD_UP_K						20055
#define KEYBOARD_UP_L						20056
#define KEYBOARD_UP_M						20057
#define KEYBOARD_UP_W						20058
#define KEYBOARD_UP_X						20059
#define KEYBOARD_UP_C						20060
#define KEYBOARD_UP_V						20061
#define KEYBOARD_UP_B						20062
#define KEYBOARD_UP_N						20063
#define KEYBOARD_UP_M_A						20064
#define KEYBOARD_UP_M_Z						20065
#define KEYBOARD_UP_M_E						20066
#define KEYBOARD_UP_M_R						20067
#define KEYBOARD_UP_M_T						20068
#define KEYBOARD_UP_M_Y						20069
#define KEYBOARD_UP_M_U						20070
#define KEYBOARD_UP_M_I						20071
#define KEYBOARD_UP_M_O						20072
#define KEYBOARD_UP_M_P						20073
#define KEYBOARD_UP_M_Q						20074
#define KEYBOARD_UP_M_S						20075
#define KEYBOARD_UP_M_D						20076
#define KEYBOARD_UP_M_F						20077
#define KEYBOARD_UP_M_G						20078
#define KEYBOARD_UP_M_H						20079
#define KEYBOARD_UP_M_J						20080
#define KEYBOARD_UP_M_K						20081
#define KEYBOARD_UP_M_L						20082
#define KEYBOARD_UP_M_M						20083
#define KEYBOARD_UP_M_W						20084
#define KEYBOARD_UP_M_X						20085
#define KEYBOARD_UP_M_C						20086
#define KEYBOARD_UP_M_V						20087
#define KEYBOARD_UP_M_B						20088
#define KEYBOARD_UP_M_N						20089
#define KEYBOARD_UP__						20090
#define KEYBOARD_UP_2POINTS					20091
#define KEYBOARD_UP_POINT 					20092
#define KEYBOARD_UP_BACKSPACE				20093
#define KEYBOARD_UP_TAB						20094
#define KEYBOARD_UP_CTRL_U					20095
//--------------------------------------------------------------
//class Action
//--------------------------------------------------------------
class SAction
{
public:
	
	int			m_Action;        //action id
	int			m_ActionNumber;	 //action number if there is more than one action chained
	char		*m_Param;		 //action parameter
		
	double		m_StartingLife;  //time when action is create
	double		m_ExecutingLife; //time when action will be executed
	bool		m_executed;      //flag if action is executed 
	
	SAction		*m_NextAction;   // to next action to chain action

	SAction()
	{
		m_NextAction=NULL;
		m_Action=0;
		m_ActionNumber=0;
		m_executed=false;
		m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
		m_ExecutingLife=-1;
		m_Param=new char[4];
		sprintf(m_Param,"NULL");
	}
	SAction(const SAction& Action)
	{
		m_NextAction=Action.m_NextAction;
		m_Action=Action.m_Action;
		m_ActionNumber=0;
		m_executed=Action.m_executed;
		m_StartingLife=Action.m_StartingLife;
		m_ExecutingLife=Action.m_ExecutingLife;
		m_Param=new char[strlen(Action.m_Param)];
		sprintf(m_Param,"%s",Action.m_Param);
	}
	SAction(int Action)
	{
		m_NextAction=NULL;
		m_Action=Action;
		m_ActionNumber=0;
		m_executed=false;
		m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
		m_ExecutingLife=-1;
		m_Param=new char[4];
		sprintf(m_Param,"NULL");
	}
	SAction(int Action,char *Param)
	{
		m_NextAction=NULL;
		m_Action=Action;
		m_ActionNumber=0;
		m_executed=false;
		m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
		m_ExecutingLife=-1;
		m_Param=new char[strlen(Param)];
		sprintf(m_Param,"%s",Param);
	}
	void SetParam(const char *Param)
	{
		m_Param=new char[strlen(Param)];
		sprintf(m_Param,"%s",Param);
	}
	bool AllActionDone()
	{
		while(this->m_NextAction!=NULL)
		{
			if(this->m_executed==false)
			{
				return false;//one action is not done return false to keep action
			}
		}
		return true;
	}
};
//--------------------------------------------------------------
//Action list
//--------------------------------------------------------------
#define START_BASIC_ACTION_MAP						0

	#define NOTHING									0
	#define QUIT									30001


	#define ENABLE_ANTIALIASING						30004
	#define DISABEL_ANTIALIASING					30005

	#define SET_RENDERMODE_TEXTURES_LIGHT			30006
	#define SET_RENDERMODE_TEXTURES					30007
	#define SET_RENDERMODE_TRIANGLES_LIGHT			30008
	#define SET_RENDERMODE_TRIANGLES				30009
	#define SET_RENDERMODE_POINTS					30010
	#define SET_RENDERMODE_LINES					30011
	#define SET_RENDERMODE_NO						30012

	#define SHOW_NET_STAT							30013
	#define HIDE_NET_STAT							30014
	#define SHOW_FPS_STAT							30015
	#define	HIDE_FPS_STAT							31116




	#define ENABLE_GRIDE							30020
	#define DISABLE_GRIDE							30021
	#define SWITCH_GRIDE							30022

	#define SET_RESOLUTION_800_600_16				30023
	#define SET_RESOLUTION_800_600_24				30024
	#define SET_RESOLUTION_800_600_32				30025
	#define SET_RESOLUTION_1024_768_16				30026
	#define SET_RESOLUTION_1024_768_24				30027
	#define SET_RESOLUTION_1024_768_32				30028
	#define SET_RESOLUTION_1600_1200_16				30029
	#define SET_RESOLUTION_1600_1200_24				30030
	#define SET_RESOLUTION_1600_1200_32				30031

	#define LOAD_COMMAND_CONFIG_FILE				30032
	#define LOAD_MODELE_FILE						30033
	#define LOAD_MAP_FILE							30034
	#define LOAD_INTERFACE_FILE						30035
	#define LOAD_SOUND_FILE							30036
	#define LOAD_CONSOLE_CONFIG_FILE				30037
	#define LOAD_FILE								30038
	#define LOAD_SET_OF_FILE						30039
	#define LOAD_EXEC_CONFIG_FILE					30043
	#define LOAD_PART_CONFIG_FILE					30047

	#define RESET									30040

	#define ENABLE_MULTIVIEW						30041
	#define DISABLE_MULTIVIEW						30042
	#define LIST_TEXTURE							30045
	#define CHECK_DEVICE							30046
	#define SET_SPECIAL_EFFECT						30047

#define END_BASIC_ACTION_MAP							30098
//-----------------------------
//Cammera Action start at 30100
//-----------------------------
#define START_CAMERA_ACTION_MAP							30099
	#define CAMERA_CURRENT_START_ROTATEX_UP			30100
	#define CAMERA_CURRENT_STOP_ROTATEX_UP			30101
	#define CAMERA_CURRENT_ROTATEX_UP				30102
	#define CAMERA_CURRENT_START_ROTATEX_DOWN		30103
	#define CAMERA_CURRENT_STOP_ROTATEX_DOWN		30104
	#define CAMERA_CURRENT_ROTATEX_DOWN				30105

	#define CAMERA_CURRENT_START_ROTATEY_UP			30106
	#define CAMERA_CURRENT_STOP_ROTATEY_UP			30107
	#define CAMERA_CURRENT_ROTATEY_UP				30108
	#define CAMERA_CURRENT_START_ROTATEY_DOWN		30109
	#define CAMERA_CURRENT_STOP_ROTATEY_DOWN		30110
	#define CAMERA_CURRENT_ROTATEY_DOWN				30111

	#define CAMERA_CURRENT_START_ROTATEZ_UP			30112
	#define CAMERA_CURRENT_STOP_ROTATEZ_UP			30113
	#define CAMERA_CURRENT_ROTATEZ_UP				30114
	#define CAMERA_CURRENT_START_ROTATEZ_DOWN		30115
	#define CAMERA_CURRENT_STOP_ROTATEZ_DOWN		30116
	#define CAMERA_CURRENT_ROTATEZ_DOWN				30117

	#define CAMERA_CURRENT_START_GOTO_TARGET		30118
	#define CAMERA_CURRENT_STOP_GOTO_TARGET			30119
	#define CAMERA_CURRENT_GOTO_TARGET				30120

	#define CAMERA_CURRENT_START_INCREASE_SPEED		30121
	#define CAMERA_CURRENT_STOP_INCREASE_SPEED		30122
	#define CAMERA_CURRENT_INCREASE_SPEED			30123

	#define CAMERA_CURRENT_START_DECREASE_SPEED		30124
	#define CAMERA_CURRENT_STOP_DECREASE_SPEED		30125
	#define CAMERA_CURRENT_DECREASE_SPEED			30126

	#define CAMERA_CURRENT_FULL_STOP				30127

	#define CAMERA_NEXT_CAM							30128
	#define CAMERA_PREV_CAM							30129

	#define CAMERA_CURRENT_ROTATEX_UP_TO			30130
	#define CAMERA_CURRENT_ROTATEX_DOWN_TO			30131
	#define CAMERA_CURRENT_ROTATEY_UP_TO			30132
	#define CAMERA_CURRENT_ROTATEY_DOWN_TO			30133
	#define CAMERA_CURRENT_ROTATEZ_UP_TO			30134
	#define CAMERA_CURRENT_ROTATEZ_DOWN_TO			30135
#define END_CAMERA_ACTION_MAP						30198

//-----------------------------
//Entite Action start at 30200
//-----------------------------
#define START_ENTITE_ACTION_MAP							30199
	#define SET_NEXT_ENTITE_CURRENT						30200
	#define ENTITE_CURRENT_INCREASE_VELOCITY_X			30201
	#define ENTITE_CURRENT_DECREASE_VELOCITY_X			30202
	#define ENTITE_CURRENT_START_INCREASE_VELOCITY_X	30203
	#define ENTITE_CURRENT_STOP_INCREASE_VELOCITY_X		30204
	#define ENTITE_CURRENT_START_DECREASE_VELOCITY_X	30205
	#define ENTITE_CURRENT_STOP_DECREASE_VELOCITY_X		30206
	#define ENTITE_CURRENT_INCREASE_VELOCITY_Y			30207
	#define ENTITE_CURRENT_DECREASE_VELOCITY_Y			30208
	#define ENTITE_CURRENT_START_INCREASE_VELOCITY_Y	30209
	#define ENTITE_CURRENT_STOP_INCREASE_VELOCITY_Y		30210
	#define ENTITE_CURRENT_START_DECREASE_VELOCITY_Y	30211
	#define ENTITE_CURRENT_STOP_DECREASE_VELOCITY_Y		30212
	#define ENTITE_CURRENT_INCREASE_VELOCITY_Z			30213
	#define ENTITE_CURRENT_DECREASE_VELOCITY_Z			30214
	#define ENTITE_CURRENT_START_INCREASE_VELOCITY_Z	30215
	#define ENTITE_CURRENT_STOP_INCREASE_VELOCITY_Z		30216
	#define ENTITE_CURRENT_START_DECREASE_VELOCITY_Z	30217
	#define ENTITE_CURRENT_STOP_DECREASE_VELOCITY_Z		30218
	#define ENTITE_CURRENT_SET_VELOCITY_X				30219
	#define ENTITE_CURRENT_SET_VELOCITY_Y				30220
	#define ENTITE_CURRENT_SET_VELOCITY_Z				30221
	#define LIST_ENTITE									30222
	#define SET_CURRENT_ENTITE							30223
	#define SET_CURRENT_ENTITE_NAME						30224

	#define ENTITE_CURRENT_START_ROTATE_X_UP			30225
	#define ENTITE_CURRENT_STOP_ROTATE_X_UP				30226
	#define ENTITE_CURRENT_ROTATE_X_UP					30227
	#define ENTITE_CURRENT_START_ROTATE_Y_UP			30228
	#define ENTITE_CURRENT_STOP_ROTATE_Y_UP				30229
	#define ENTITE_CURRENT_ROTATE_Y_UP					30230
	#define ENTITE_CURRENT_START_ROTATE_Z_UP			30231
	#define ENTITE_CURRENT_STOP_ROTATE_Z_UP				30232
	#define ENTITE_CURRENT_ROTATE_Z_UP					30233

	#define ENTITE_CURRENT_START_ROTATE_X_DOWN			30234
	#define ENTITE_CURRENT_STOP_ROTATE_X_DOWN			30235
	#define ENTITE_CURRENT_ROTATE_X_DOWN				30236
	#define ENTITE_CURRENT_START_ROTATE_Y_DOWN			30237
	#define ENTITE_CURRENT_STOP_ROTATE_Y_DOWN			30238
	#define ENTITE_CURRENT_ROTATE_Y_DOWN				30239
	#define ENTITE_CURRENT_START_ROTATE_Z_DOWN			30240
	#define ENTITE_CURRENT_STOP_ROTATE_Z_DOWN			30241
	#define ENTITE_CURRENT_ROTATE_Z_DOWN				30242
	
	#define ENTITE_CURRENT_SET_ROTATE_X					30243
	#define ENTITE_CURRENT_SET_ROTATE_Y					30244
	#define ENTITE_CURRENT_SET_ROTATE_Z					30245

#define END_ENTITE_ACTION_MAP							30298
//-----------------------------
//Sound Action start at 30300	
//-----------------------------
#define START_SOUND_ACTION_MAP						30299
	#define LIST_SOUND								30300
	#define REMOVE_SOUND							30301
	#define PLAY_SOUND								30302
	#define STOP_SOUND								30303
	#define SET_REPEATS_SOUND						30304
	#define GET_REPEATS_SOUND						30305
	#define ADD_SOUND								30306
#define END_SOUND_ACTION_MAP						30398
//-------------------------------
//Interface Action start at 30400	
//-------------------------------
#define START_INTERFACE_ACTION_MAP					30399
	#define SHOW_INTERFACE_REGION					30400
	#define HIDE_INTERFACE_REGION					30401
	#define LIST_INTERFACE							30402
	#define ENABLE_INTERFACE						30403
	#define DISABLE_INTERFACE						30404
	#define ADD_INTERFACE							30405
	#define ENABLE_ALL_INTERFACE					30406
	#define DISABLE_ALL_INTERFACE					30407
#define END_INTERFACE_ACTION_MAP					30498
//-------------------------------
//Map Action start at 30500	
//-------------------------------
#define START_MAP_ACTION_MAP						30499
	#define SHOW_MAP_SKY_BOX						30500
	#define HIDE_MAP_SKY_BOX						30501
	#define SHOW_MAP_MESH							30502
	#define HIDE_MAP_MESH							30503
	#define ENABLE_MAP_OCTREE						30504
	#define DISABLE_MAP_OCTREE						30505
	#define SHOW_MAP_OCTREE_SUBDIVISON				30506
	#define HIDE_MAP_OCTREE_SUBDIVISON				30507
#define END_MAP_ACTION_MAP							30598

//-------------------------------
//fog Action start at 30600	
//-------------------------------
#define START_FOG_ACTION_MAP						30599
	#define ENABLE_FOG								30600
	#define DISABEL_FOG								30601
	#define SET_FOG_COLOR_R							30602
	#define SET_FOG_COLOR_G							30603
	#define SET_FOG_COLOR_B							30604
	#define SET_FOG_START_POINT						30605
	#define SET_FOG_END_POINT						30606
	#define SET_FOG_DENSITY							30607
	#define SET_FOG_ALGO_LINEAR						30608
	#define SET_FOG_ALGO_EXP2						30609
	#define SET_FOG_ALGO_EXP						30610
#define END_FOG_ACTION_MAP							30698
//---------------------------------------
//Particule systeme Action start at 30700	
//---------------------------------------
#define START_PARTICULESYSTEME_ACTION_MAP			30699
	#define LOAD_PARTICULESYSTEME					30700
	#define STAR_PARTICULESYSTEME					30701
	#define STOP_PARTICULESYSTEME					30702
	#define PAUSE_PARTICULESYSTEME					30703
	#define STAR_ALL_PARTICULESYSTEME				30704
	#define STOP_ALL_PARTICULESYSTEME				30705
	#define PAUSE_ALL_PARTICULESYSTEME				30706
	#define LIST_PARTICULESYSTEME					30707
#define END_PARTICULESYSTEME_ACTION_MAP				30799

//-----------------------------
//Consol Action start at 30800
//-----------------------------
#define START_CONSOL_ACTION_MAP						30800
	#define ENABLE_CONSOL_BACKGROUND_TEXTURE		30801
	#define DISABLE_CONSOL_BACKGROUND_TEXTURE		30802
 	#define SET_CONSOL_BACKGROUND_TEXURE			30803
	#define SET_CONSOL_BACKGROUND_COLOR				30804
	#define SET_CONSOL_BACKGROUND_COLOR_BLUE		30805
	#define SET_CONSOL_BACKGROUND_COLOR_GREEN		30806
	#define SET_CONSOL_BACKGROUND_COLOR_RED			30807
	#define ENABLE_CONSOL_BACKGROUND_BLENDING		30809
	#define DISABLE_CONSOL_BACKGROUND_BLENDING		30810
	#define SET_CONSOL_BACKGROUND_BLENDING			30811
	#define SHOW_FULL_CONSOL						30812
	#define SHOW_HALF_CONSOL						30813
	#define HIDE_CONSOL								30814
	#define CONSOL_NEXT_AVIABLE_STATE				30815
	#define CONSOL_LINE_UP							30816
	#define CONSOL_LINE_DOWN						30817
#define END_CONSOL_ACTION_MAP						30899
//-----------------------------
//CUSTOM Action start at 40000
//-----------------------------
#define START_CUSTOM_ACTION_ACTION_MAP				39999
	#define CUSTOM_ACTION_1							40001
	#define CUSTOM_ACTION_2							40002
	#define CUSTOM_ACTION_3							40003
	#define CUSTOM_ACTION_4							40004
#define END_CUSTOM_ACTION_ACTION_MAP				50000

#endif
