/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCFrustum.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __EXCFRUSTUM_H__
#define __EXCFRUSTUM_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "Math/ExMath.h"

//--------------------------------
class ExCFrustum 
{
private:
//--------------------------------
// Variable
//--------------------------------
	float m_Frustum[6][4];
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCFrustum(void);
	~ExCFrustum(void);
//--------------------------------
// Methode
//--------------------------------
	void CalculateFrustum();
	bool PointInFrustum(float x, float y, float z);
	bool SphereInFrustum(float x, float y, float z, float radius);
	bool CubeInFrustum( float x, float y, float z, float size );
	bool BoxInFrustrum(ExCVertex point[8]);
};
#endif //__EXCFRUSTRUM_H__
