/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCMatrix4x4.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __EXCMATRIX4X4_H__
#define __EXCMATRIX4X4_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include <math.h>
#include <cmath>
//--------------------------------
class ExCMatrix4x4  
{
public:
//--------------------------------
// Variable
//--------------------------------
	float m_Matrix[16];
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCMatrix4x4();
	~ExCMatrix4x4();
//--------------------------------
// Methode
//--------------------------------
	void SetLine(short line,float c1,float c2,float c3,float c4);
	void SetColone(short colone,float l1,float l2,float l3,float l4);
	void SetMatrix(float Matrix[16]);
	void SetMatrix(float l1c1,float l1c2,float l1c3,float l1c4,
					float l2c1,float l2c2,float l2c3,float l2c4,
					float l3c1,float l3c2,float l3c3,float l3c4,
					float l4c1,float l4c2,float l4c3,float l4c4);
	float GetDeterminant(void);
	void LoadIdentity(void);
	ExCMatrix4x4 GetTransposee(void);
//--------------------------------
// Operator
//--------------------------------
	ExCMatrix4x4 operator- (const ExCMatrix4x4 &m2);
	ExCMatrix4x4 operator+ (const ExCMatrix4x4 &m2);
	ExCMatrix4x4 operator* (const float scalar);
	ExCMatrix4x4 operator* (const ExCMatrix4x4 &m2);
//--------------------------------
// friends
//--------------------------------
	friend std::ostream& operator<<(std::ostream& s,const ExCMatrix4x4 &m);
};

#endif // __EXCMATRIX4X4_H__
