/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCMesh.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __EXCMESH_H__
#define __EXCMESH_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExCVertex.h"
//--------------------------------
class ExCMesh
{
public:
//--------------------------------
// Variable
//--------------------------------
	ExCVertex	A;
	ExCVertex	B;
	ExCVertex	C;
	int			m_AB;
	int			m_BC;
	int			m_CA;
	int			m_Smoothing;
	char		*m_Material;
	int			m_MeshNumber;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCMesh(void);
	ExCMesh(ExCVertex  a,ExCVertex  b,ExCVertex  c);
	~ExCMesh(void);
//--------------------------------
// Methode
//--------------------------------
	void Affich(void);
	void SetMaterial(const char *Material);
	void SetVertex(ExCVertex  a,ExCVertex  b,ExCVertex  c);
	inline char * GetMaterial(void){return m_Material;}
	inline int GetMeshNumber(void){return m_MeshNumber;}
	inline int GetSmoothing(void){return  m_Smoothing;};
	inline int GetAB(void){return m_AB;}
	inline int GetBC(void){return m_BC;}
	inline int GetCA(void){return m_CA;}
	inline void SetVertexA(ExCVertex  a){A=a;}
	inline void SetVertexB(ExCVertex  b){B=b;}
	inline void SetVertexC(ExCVertex  c){C=c;}
};
#endif //__EXCMESH_H__
