/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCVec3D.h,v 1.6 2002/07/08 23:14:46 data Exp $
 *
 */


#ifndef __EXCVEC3D_H__
#define __EXCVEC3D_H__

#include "ExDefine.h"
#include <math.h>
#include <cmath>

class ExCVec3D  
{
public:
//--------------------------------
//Variable
//--------------------------------
	float m_Vector[3];
//--------------------------------
//Constructor // Destructor
//--------------------------------
	ExCVec3D();
	ExCVec3D(float x,float y,float z);
	~ExCVec3D();
//--------------------------------
//Methode
//--------------------------------
	float GetVectorLenght(void);
	ExCVec3D GetVecNormale(void);
	void SetValue(float x,float y,float z);
	inline void SetX(double val){m_Vector[0]=val;}
	inline void SetY(double val){m_Vector[1]=val;}
	inline void SetZ(double val){m_Vector[2]=val;}
	inline double GetX(void){return m_Vector[0];}
	inline double GetY(void){return m_Vector[1];}
	inline double GetZ(void){return m_Vector[2];}
	void Draw(void);
//--------------------------------
// Operator
//--------------------------------
	ExCVec3D& operator=(const ExCVec3D& Vec);
	bool  operator==(const ExCVec3D& Vec);
	ExCVec3D  operator+(const ExCVec3D& Vec);
	ExCVec3D  operator-(const ExCVec3D& Vec);
	ExCVec3D  operator*(const ExCVec3D& Vec);
	ExCVec3D  operator*(float scalar);
	ExCVec3D  operator/(const ExCVec3D& Vec);
	ExCVec3D  operator/(float scalar);
//--------------------------------
// friends
//--------------------------------	
	friend std::ostream& operator<<(std::ostream& s,const ExCVec3D &vec);

};

#endif // __EXCVEC3D_H__
