/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCVertex.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __ExCVertex_H__
#define __ExCVertex_H__ 

#include "ExDefine.h"
#include <math.h>
#include <cmath>
class ExCVertex
{
private:
	double m_dA;	//Alpha
	double m_dB;	//Blue
	double m_dG;	//Green
	double m_dR;	//Red
	double m_dU;	//U texture
	double m_dV;	//V texture
	double m_dW;	//W texture
	double m_dX;	//X position
	double m_dY;	//Y position
	double m_dZ;	//Z position
public:
	ExCVertex(void);
	ExCVertex(double x,double y,double z);
	ExCVertex(double x,double y,double z,double u,double v);
	ExCVertex(double x,double y,double z,double r,double g,double b,double a);
	ExCVertex(double x,double y,double z,double u,double v,double r,double g,double b,double a);
//	ExCVertex(ExCVertex& copy);
	
	~ExCVertex(void);

/*	ExCVertex& operator=(const ExCVertex& vertex);
	ExCVertex operator+(ExCVertex a);
	ExCVertex operator-(ExCVertex a);
	bool operator ==(const ExCVertex a);*/

	inline void SetX(double val){m_dX=val;}
	inline void SetY(double val){m_dY=val;}
	inline void SetZ(double val){m_dZ=val;}
	inline void SetU(double val){m_dU=val;}
	inline void SetV(double val){m_dV=val;}
	inline void SetR(double val){m_dR=val;}
	inline void SetG(double val){m_dG=val;}
	inline void SetB(double val){m_dB=val;}
	inline void SetA(double val){m_dA=val;}
	inline void SetW(double val){m_dW=val;}

	inline double GetX(void){return m_dX;}
	inline double GetY(void){return m_dY;}
	inline double GetZ(void){return m_dZ;}
	inline double GetU(void){return m_dU;}
	inline double GetV(void){return m_dV;}
	inline double GetA(void){return m_dA;}
	inline double GetB(void){return m_dB;}
	inline double GetG(void){return m_dG;}
	inline double GetR(void){return m_dR;}
	inline double GetW(void){return m_dW;}

	inline void IncX(double val){m_dX=m_dX+val;}
	inline void IncY(double val){m_dY=m_dY+val;}
	inline void IncZ(double val){m_dZ=m_dZ+val;}
	
	inline void DecX(double val){m_dX=m_dX-val;}
	inline void DecY(double val){m_dY=m_dY-val;}
	inline void DecZ(double val){m_dZ=m_dZ-val;}


	inline void Affich(void){std::cout<<"X:"<<m_dX<<" Y:"<<m_dY<<" Z:"<<m_dZ;}

};

#endif //__ExCVertex_H__
