/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExMath.h,v 1.6 2002/07/08 23:14:46 data Exp $
 *
 */

#ifndef __EXMATH_H__
#define __EXMATH_H__

#include <math.h>
#include <cmath>
#include "ExCVertex.h"
#include "ExCMesh.h"
#include "ExCVec3D.h"
#include "ExCMatrix4x4.h"
#include "ExCMatrix3x3.h"
#include "ExQuaternion.h"
#include "ExCFrustum.h"
#include "cos.h"
#include "sin.h"


ExCMatrix4x4 MatriceByVec3D(const ExCMatrix4x4 &m,const ExCVec3D &v);
float GetDotProduct(const ExCVec3D& Vec1,const ExCVec3D& Vec2);
ExCVec3D GetCrossProduct(const ExCVec3D& Vec1,const ExCVec3D& Vec2);
ExCVec3D GetVecNormale(const ExCVec3D& Vec1);
ExCMatrix4x4 GetMatrixFromQuaternion(const ExQuaternion& Q);
ExCMatrix4x4 GetMatrixFromEuler(float roll,float pitch,float yaw);
ExQuaternion GetQuaternionFromEuler(float x,float y,float z);
void NormalizePlane(float Plane[6][4], int side);
inline float DegreesToRadians(float deg){return deg * PI/180.0f;}
inline float RadiansToDegrees(float rad){return rad * 180.0f /PI;}

ExCVec3D GetAxisFromQuaternion(const ExQuaternion& Q);

ExCVec3D  GetNewVecFromEuler(ExCVec3D force,float roll,float pitch,float yaw);
#endif //__EXMATH_H__
