/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/
/* For contact  : Hermanns Christophe									*/
/* Mail         : Data@skynet.be										*/
/* ICQ          : 8030901												*/
/* MSN Messenger: Data_7@hotmail.com									*/
/************************************************************************/ 

/************************************************************************/
/* File Name   :ExQuaternion.h											*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :03/15/2002												*/
/*																		*/
/* File Description :Quaternion Class									*/
/*					 Operation on Quaternion							*/
/************************************************************************/


/* $Id: ExQuaternion.h,v 1.2 2002/05/29 00:03:58 binny Exp $ */

#ifndef __EXQUATERNION_H__
#define __EXQUATERNION_H__

#include "ExDefine.h"
#include <math.h>
#include <cmath>
class ExQuaternion  
{
public:
//--------------------------------
//Variable
//--------------------------------
	float qw,qx,qy,qz;
//--------------------------------
//Constructor // Destructor
//--------------------------------
	ExQuaternion();
	ExQuaternion(float w,float x,float y,float z);
	~ExQuaternion();
//--------------------------------
//Methode
//--------------------------------
	void LoadIdentity(void);
	void SetQuaternion(float w,float x,float y,float z);
	//void SetQuaternion();
	void Normalize(void);
	void Conjugate(void);
	float GetMagnitude(void);
	void SetEuler(float yaw,float pitch,float roll);
//--------------------------------
// Operator
//--------------------------------
	ExQuaternion operator- (const ExQuaternion &Q);
	ExQuaternion operator+ (const ExQuaternion &Q);
	ExQuaternion operator* (const float scalar);
	ExQuaternion operator* (const ExQuaternion &Q);
//--------------------------------
// friends
//--------------------------------
	friend std::ostream& operator<<(std::ostream& s,const ExQuaternion &q);
};

#endif // __EXQUATERNION_H__
