/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCCamera.h,v 1.5 2002/07/02 13:48:46 data Exp $
 *
 */

#ifndef __EXCCAMERA_H__
#define __EXCCAMERA_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCObject.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
//--------------------------------
class ExCCamera : public ExCObject
{
protected:
//--------------------------------
// Variable
//--------------------------------
	bool m_Actif;
	float m_Zoom;
	float m_ClipFar;
	float m_ClipNear;
	float m_ZoomDefault;
	float m_ZoomMax;
	float m_ZoomMin;
	ExCVec3D VecX,VecY,VecZ,VecDir;
	ExCVec3D m_vPosition,m_vView,m_vUpVector;
public:
	int			m_speed;
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCCamera(void);
	~ExCCamera(void);
//--------------------------------
// Methode
//--------------------------------
	void Draw(void);
	void ZoomIn(void);
	void ZoomOut(void);
	void ResetZoom(void);
	void ZoomIn(float zoom);
	void ZoomOut(float zoom);
	
	void SetZoom(float zoom);
	void SetZoomMax(float zoom);
	void SetZoomMin(float zoom);
	void SetZoomDefault(float zoom);
	void SetClipFar(float clip);
	void SetClipNear(float clip);
	

	float GetZoomMax(void){return m_ZoomMax;}
	float GetZoomMin(void){return m_ZoomMin;}
	float GetZoom(void){return m_Zoom;}
	float GetZoomDefault(void){return m_ZoomDefault;}
	float GetClipFar(void){return m_ClipFar;}
	float GetClipNear(void){return m_ClipNear;}

	void GoToView(bool state);

	void RotateView(float X, float Y, float Z);
	void StrafeCamera(float speed);
	void MoveCamera(float speed);
//--------------------------------
// Operator
//--------------------------------
//--------------------------------
// friends
//--------------------------------
};
#endif //__EXCCAMERA_H__
