/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCEntite.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __EXCENTITE_H__
#define __EXCENTITE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCObject.h"
#include "ExCGizmoRectangle.h"
//--------------------------------
class ExCEntite : public ExCObject
{
protected:
//--------------------------------
// Variable
//--------------------------------
	std::vector<ExCVertex> m_VecVertex;
	std::vector<ExCVertex>::iterator m_ItVecVertex;
	std::vector<ExCMesh> m_VecMesh;
	std::vector<ExCMesh>::iterator m_ItVecMesh;
	
	long			m_NumberVertex;
	long			m_NumberMesh;
	int				m_RenderMode;
	GLuint			m_GlListId;

	
	//--------------------------------
	// Methode
	//--------------------------------
	
public:
	ExCGizmoRectangle	m_BoxPvs;
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCEntite(void);
	~ExCEntite(void);
//--------------------------------
// Methode
//--------------------------------
	inline void SetNumberVertex(long NumberVertex){m_NumberVertex=NumberVertex;}
	inline void SetNumberMesh(long NumberMesh){m_NumberMesh=NumberMesh;}

	inline long GetNumberVertex(void){return m_NumberVertex;}
	inline long GetNumberMesh(void){return m_NumberMesh;}
	inline int GetRenderMode(void){return m_RenderMode;}
	inline GLuint GetGlListId(void){return m_GlListId;}
    
	virtual void Draw(void);
	void DrawWithoutList(void);
	virtual bool LoadAsc(char *FileName);
	virtual void MakeList(void);
    virtual void SetRenderMode(int RenderMode);

	void AddVertex(ExCVertex Vertex);
	void AddMesh(ExCMesh Mesh);
	ExCVertex GetVertex(int pos); 

	void BuildPvsBox(void);
};
#endif //__EXCENTITE_H__
