 /*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCImage.h,v 1.2 2002/08/01 19:37:49 binny Exp $
 *
 */


//-----------------------------------------
//Lib for loading data from != image format
//-----------------------------------------
//Current format supported
//-----------------------------------------
// .Bmp
//-----------------------------------------
//Format to developpe
//-----------------------------------------
// .tga
// .jpg
// .rgb
// .raw
// .ppm
//-----------------------------------------


#ifndef __EXCIMAGE_H__
#define __EXCIMAGE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
//--------------------------------
// Define type
//--------------------------------
#define TGA_RGB		 2		// Normal RGB file
#define TGA_A		 3		// ALPHA file
#define TGA_RLE		10		// Run-Length Encoded (RLE) file

#ifdef UNIX_SRC
typedef unsigned int WORD;
#endif

//-------------------------------
struct tImage
{
	int channels;			// The channels in the image (3 = RGB : 4 = RGBA)
	int sizeX;				// The width of the image in pixels
	int sizeY;				// The height of the image in pixels
	unsigned char *data;	// The image pixel data
	unsigned int	type;	// RGB,RGBA...
};
//--------------------------------
bool LoadBMP(tImage *image,const char *strFileName);
bool LoadTGA(tImage *image,const char *strFileName);
bool LoadJPG(tImage *image,const char *strFileName);

bool LoadBMP(tImage *image,std::string strFileName);
bool LoadTGA(tImage *image,std::string strFileName);
bool LoadJPG(tImage *image,std::string strFileName);

//void DecodeJPG(jpeg_decompress_struct* cinfo, tImage *pImageData);

#endif

