/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCInterface.h,v 1.2 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXCINTERFACE_H__
#define __EXCINTERFACE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "InputActionList.h"
#include "ExManagerWindow.h"
#include "ExManagerTexture.h"
#include "ExCFile.h"

//--------------------------------
class ExCInterface
{
private:
//--------------------------------
// Variable
//--------------------------------
	ExManagerWindow		*ManagerWindow;
	ExManagerTexture	*ManagerTexture;
	char				*m_Texture;
	char				*m_TextureMask;
	GLuint				m_iTexture;
	GLuint				m_iTextureMask;
	int					m_NumInterface;
	int					m_DefaultResolutionX;
	int					m_DefaultResolutionY;
	bool				m_ShowRegion;
	bool				m_State;
	char				*m_InterfaceName;
	struct ActionCommand
	{
		int		m_Action;
		int		m_Command;
		char 	m_Param[255];
		int		m_MouseXup;
		int		m_MouseYup;
		int		m_MouseXdown;
		int		m_MouseYdown;
	};
	std::vector<ActionCommand>			 m_VecActionCommand;
	std::vector<ActionCommand>::iterator m_ItVecActionCommand;
	
	void LoadTextureInterface(void);
public:
	std::ostrstream *Consol;
	void (*WriteToConsol)(const char *Label);
	ExCInterface(void);
	~ExCInterface(void);
//--------------------------------
// Methode
//--------------------------------
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	
	inline void SetNumInterface(int num){m_NumInterface=num;}
	inline int	GetNumInterface(void ){return m_NumInterface;}

	inline	void ShowRegion(void){m_ShowRegion=true;}
	inline	void HideRegion(void){m_ShowRegion=false;}
	inline	void DisableInterface(void){m_State=false;}
	inline	void EnableInterface(void){m_State=true;}
	inline  bool GetInterfaceState(void){return m_State;}

	inline char * GetInterfaceName(void){return m_InterfaceName;}
	void DrawInterface(void);
	bool LoadInterface(const char * FileName);
	SAction InputCommand(int command,int mousex,int mousey);

};
#endif //__EXCINTERFACE_H__
