/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCLight.h,v 1.5 2002/07/02 13:48:46 data Exp $
 *
 */

#ifndef __EXCLIGHT_H__
#define __EXCLIGHT_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCObject.h"
//--------------------------------
class ExCLight : public ExCObject
{
protected:
//--------------------------------
// Variable
//--------------------------------
	GLenum m_LightNumber;   //Light number for opengl GL_LIGHT0 for ex.
	bool m_State;			//State if Light is on or off
	float m_ambiant[4] ;	//Ambiant  Param R,G,B,A
	float m_diffuse[4] ;	//Diffuse  Param R,G,B,A
	float m_specular[4];	//Specular Param R,G,B,A
		
	float m_spotExponent[1];
	float m_spotCutOff[1];
	
	float m_spotConstentAtt[1];
	float m_spotLinearAtt[1];
	float m_spotQuadraticAtt[1];
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCLight(void);
	ExCLight(GLenum Number);
	~ExCLight(void);
//--------------------------------
// Methode
//--------------------------------
	void Reset(void);

	void SetLightNumber(GLenum light);
	void TurnOn(void);
	void TurnOff(void);
	inline bool GetState(void){return m_State;}

	void  SetAmbiant(float R,float G,float B,float A);
	void  SetAmbiantR(float R);
	void  SetAmbiantG(float G);
	void  SetAmbiantB(float B);
	void  SetAmbiantA(float A);
	float GetAmbiantR(void);
	float GetAmbiantG(void);
	float GetAmbiantB(void);
	float GetAmbiantA(void);
	void  IncAmbiantR(float inc);
	void  IncAmbiantG(float inc);
	void  IncAmbiantB(float inc);
	void  IncAmbiantA(float inc);
	
	void  SetDiffuse(float R,float G,float B,float A);
	void  SetDiffuseR(float R);
	void  SetDiffuseG(float G);
	void  SetDiffuseB(float B);
	void  SetDiffuseA(float A);
	float GetDiffuseR(void);
	float GetDiffuseG(void);
	float GetDiffuseB(void);
	float GetDiffuseA(void);
	void  IncDiffuseR(float inc);
	void  IncDiffuseG(float inc);
	void  IncDiffuseB(float inc);
	void  IncDiffuseA(float inc);

	void  SetSpecular(float R,float G,float B,float A);
	void  SetSpecularR(float R);
	void  SetSpecularG(float G);
	void  SetSpecularB(float B);
	void  SetSpecularA(float A);
	float GetSpecularR(void);
	float GetSpecularG(void);
	float GetSpecularB(void);
	float GetSpecularA(void);
	void  IncSpecularR(float inc);
	void  IncSpecularG(float inc);
	void  IncSpecularB(float inc);
	void  IncSpecularA(float inc);

	void  SetPosition(double X,double Y,double Z);
	void  SetPosition(double X,double Y,double Z,double W);
	void  SetPositionX(double X);
	void  SetPositionY(double Y);
	void  SetPositionZ(double Z);
	void  SetPositionW(double W);
	inline float GetPositionX(void){return m_Position.GetX();}
	inline float GetPositionY(void){return m_Position.GetY();}
	inline float GetPositionZ(void){return m_Position.GetZ();}
	inline void  IncPositionX(float inc){SetPositionX(GetPositionX()+inc);}
	inline void  IncPositionY(float inc){SetPositionY(GetPositionY()+inc);}
	inline void  IncPositionZ(float inc){SetPositionZ(GetPositionZ()+inc);}
	
	void  SetTarget(double X,double Y,double Z);
	void  SetTargetX(double X);
	void  SetTargetY(double Y);
	void  SetTargetZ(double Z);
	inline float GetTargetX(void){return m_Target.GetX();}
	inline float GetTargetY(void){return m_Target.GetY();}
	inline float GetTargetZ(void){return m_Target.GetZ();}
	inline void  IncTargetX(float inc){SetTargetX(GetTargetX()+inc);}
	inline void  IncTargetY(float inc){SetTargetY(GetTargetY()+inc);}
	inline void  IncTargetnZ(float inc){SetTargetZ(GetTargetZ()+inc);}
	
	void  SetSpotExponent(float Exponent);
	void  IncSpotExponent(float inc);
	float GetSpotExponent(void);

	void  SetSpotCutOff(float cut);
	void  IncSpotCutOff(float inc);
	float GetSpotCutOff(void);

	void  SetConstantAttenuation(float att);
	void  IncConstantAttenuation(float inc);
	float GetConstantAttenuation(void);

	void  SetLinearAttenuation(float att);
	void  IncLinearAttenuation(float inc);
	float GetLinearAttenuation(void);

	void  SetQuadraticAttenuation(float att);
	void  IncQuadraticAttenuation(float inc);
	float GetQuadraticAttenuation(void);
};
#endif //__EXCLIGHT_H__
