/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCMap.h,v 1.8 2002/08/01 18:45:56 data Exp $
 *
 */

#ifndef __EXMAP_H__
#define __EXMAP_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerTexture.h"
#include "ExCGizmoRectangle.h"
#include "ExCFrustum.h"
#include "ExCOctree.h"

//--------------------------------
class ExCMap
{
protected:
//--------------------------------
// Variable
//--------------------------------

	ExManagerTexture		*ManagerTexture;	
	
	std::vector<ExCVertex> m_VecVertex;
	std::vector<ExCVertex>::iterator m_ItVecVertex;
	std::vector<ExCMesh> m_VecMesh;
	std::vector<ExCMesh>::iterator m_ItVecMesh;
	

	long			m_NumberMesh;
	long			m_NumberVertex;
	int				m_RenderMode;
	
	GLuint			m_GlListId;
	GLuint			m_GlSkyBoxListId;

	bool			m_ShowSkybox;
	bool			m_ShowMesh;
	bool			m_OctreeState;
	bool			m_ShowOctreeSubdivision;

	

	void DrawAllMesh(void);
	void DrawMeshInFrustrum(void);
	void BuildSkyBox(void);
	void BuildOctree(void);
	void BuilList(void);
	void BuildVertexArrays(void);



	ExCOctree m_Octree;
	ExCFrustum				Frustrum;
public:

	char			*m_STextureBoxNameTop;
	char			*m_STextureBoxNameBottom;
	char			*m_STextureBoxNameFront;
	char			*m_STextureBoxNameBack;
	char			*m_STextureBoxNameLeft;
	char			*m_STextureBoxNameRight;
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCMap(void);
	~ExCMap(void);
//--------------------------------
// Methode
//--------------------------------
	inline void ShowSkybox(void){m_ShowSkybox=true;}
	inline void HideSkybox(void){m_ShowSkybox=false;}
	inline void ShowMesh(void){m_ShowMesh=true;}
	inline void HideMesh(void){m_ShowMesh=false;}
	inline void EnableOctree(void){m_OctreeState=true;}
	inline void DisableOctree(void){m_OctreeState=false;}
	inline void ShowOctreeSubdivision(void){m_ShowOctreeSubdivision=true;}
	inline void HideOctreeSubdivision(void){m_ShowOctreeSubdivision=false;}

	std::ostrstream *Consol;
 	void (*WriteToConsol)(const char *Label);

	inline void SetNumberMesh(long NumberMesh){m_NumberMesh=NumberMesh;}

	inline long GetNumberMesh(void){return m_NumberMesh;}
	inline int GetRenderMode(void){return m_RenderMode;}
	inline GLuint GetGlListId(void){return m_GlListId;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	
	bool LoadMap(const char *FileName);
	void Draw(void);


};
#endif //__EXMAP_H__
