/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCObject.h,v 1.10 2002/07/26 18:43:55 data Exp $
 *
 */

#ifndef __EXOBJECT_H__
#define __EXOBJECT_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCTime.h"
#include "ExManagerTexture.h"
#include "ExPredefinedObject.h"
//--------------------------------
class ExCObject  
{
protected:
//--------------------------------
// Variable
//--------------------------------
	ExManagerTexture	*ManagerTexture;
	ExId				m_ObjectId;
	char *				m_ObjectName;

	ExCVec3D			m_Position;
	ExCVec3D			m_Target;
	ExCVec3D			m_Velocity;
	ExCVec3D			m_Gravity;

	double				m_Acceleration;

	double				m_RefreshTime;

	double				m_Life;
	double				m_StartingLife;
    float				m_Size;
	float				m_Mass;
	bool				m_ShowInfo;
	bool				m_CurrentObject;

public:
	float		m_AngleX;
	float		m_AngleY;
	float		m_AngleZ;

//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCObject();
	virtual ~ExCObject();
//--------------------------------
// Methode
//--------------------------------
	virtual void Draw(void);
	virtual void SetManagerTexture(ExManagerTexture * Texture);

	void SetCurrentState(bool state){m_CurrentObject=state;}
    
	//--------------------------------------------------------
	void ShowInfo(void);
	inline void SetShowInfoState(bool state){m_ShowInfo=state;}
	inline bool GetShowInfoState(void){return m_ShowInfo;}
	//--------------------------------------------------------
	void SetIdName(IdName idname);
	inline void SetId(ExId Id){m_ObjectId=Id;}
	inline ExId GetId(void){return m_ObjectId;}
	inline char * GetName(void){return m_ObjectName;}
	void SetName(const char * Name);
	//--------------------------------------------------------
	void SetAngleX(float Angle);
	void SetAngleY(float Angle);
	void SetAngleZ(float Angle);
	inline float GetAngleX(void){return m_AngleX;}
	inline float GetAngleY(void){return m_AngleY;}
	inline float GetAngleZ(void){return m_AngleZ;}
	//--------------------------------------------------------
	inline void		SetAcceleration(double Acceleration) {m_Acceleration=Acceleration;}
	inline double	GetAcceleration(void)	{return m_Acceleration;}
	//--------------------------------------------------------
	inline void		SetVelocity(ExCVec3D Velocity) {m_Velocity=Velocity;}
	inline void		SetVelocity(float x,float y,float z){m_Velocity=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetVelocity(void)	{return m_Velocity;}
	//--------------------------------------------------------
	inline void		SetGravity(ExCVec3D Gravity){m_Gravity=Gravity;}
	inline void		SetGravity(float x,float y,float z){m_Gravity=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetGravity(void)	{return m_Gravity;}
	//--------------------------------------------------------
	inline void		SetPosition(ExCVec3D Position){m_Position=Position;}
	inline void		SetPosition(float x,float y,float z){m_Position=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetPosition(void)	{return m_Position;}
	//--------------------------------------------------------
	inline void		SetTarget(ExCVec3D Target){m_Target=Target;}
	inline void		SetTarget(float x,float y,float z){m_Target=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetTarget(void)	{return m_Target;}
	//--------------------------------------------------------
	void Rotate(float angleX,float angleY,float angleZ);
	void Rotate(void);
};

#endif // __EXOBJECT_H__
