/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCOctree.h,v 1.4 2002/06/16 00:51:04 binny Exp $
 *
 */

#ifndef __EXCOCTREE_H__
#define __EXCOCTREE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCFrustum.h"
#include "ExManagerTexture.h"
#include "ExCGizmoRectangle.h"
#define MAX_MESH_IN_CUBE		200
#define MAX_SUBDIVISION			5
//--------------------------------
class ExCOctree 
{
private:

//--------------------------------
// Variable
//--------------------------------
	ExManagerTexture	*ManagerTexture;
    ExCGizmoRectangle	m_GLobalBox;
	long				m_NumberMesh;
	GLuint				m_GlListId;
	int					m_SubDivisionLevel;
	bool				m_ShowOctreeSubdivision;
	ExCFrustum			Frustrum;
	double				maxsegment;
	

	ExCOctree *A,*B,*C,*D,*E,*F,*G,*H;
	void BuildFirstBox(void);
	void BuildBox(ExCVertex center,double size);
	void BuilList(void);
	void SubDivise(void);
	bool MeshInOctree(ExCMesh Mesh,ExCOctree *octree);
public:
//--------------------------------
// Constructor // Destructor				  
//--------------------------------
	ExCOctree(void);
	ExCOctree(std::vector<ExCMesh> VecMesh);
	~ExCOctree(void);
//--------------------------------
// Methode
//--------------------------------
	std::vector<ExCMesh> m_VecMesh;
	std::vector<ExCMesh>::iterator m_ItVecMesh;

	inline void SetSubDivisionLevel(long SubDivisionLevel){m_SubDivisionLevel=SubDivisionLevel;}
	inline long GetSubDivisionLevel(void){return m_SubDivisionLevel;}
	inline void SetNumberMesh(long NumberMesh){m_NumberMesh=NumberMesh;}
	inline long GetNumberMesh(void){return m_NumberMesh;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	inline void ShowOctreeSubdivision(void){m_ShowOctreeSubdivision=true;}
	inline void HideOctreeSubdivision(void){m_ShowOctreeSubdivision=false;}
	void Build(std::vector<ExCMesh> VecMesh);
	void Draw(void);
};
#endif //__EXCOCTREE_H__
