/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCSound.h,v 1.5 2002/06/27 10:37:43 data Exp $
 *
 */

#ifndef __EXCSOUND_H__
#define __EXCSOUND_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
//--------------------------------
class ExCSound
{
#ifndef UNIX_SRC
//--------------------------------
// Variable
//--------------------------------
public:
	char						*m_FileName;
	
public:
	//--------------------------------
	// Constructor // Destructor
	//--------------------------------
	ExCSound(void);
	ExCSound(const ExCSound& sound);
	ExCSound(char *FileName);
	~ExCSound(void);
	//--------------------------------
	// Methode
	//--------------------------------
	inline char* GetName(void){return m_FileName;}
	
	bool Load(const char * FileName);
	void Play(void);
	void Stop(void);
	bool InitCom(void);
#endif // UNIX_SRC
};
#endif //__EXCSOUND_H__
