/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCSystemeParticule.h,v 1.14 2002/07/08 23:14:46 data Exp $
 *
 */

#ifndef __EXSYSTEMEPARTICULE_H__
#define __EXSYSTEMEPARTICULE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExMath.h"
#include "ExCObject.h"
#include "ExCParticule.h"
#include "ExCRandomNumber.h"
#include "ExManagerTexture.h"
//--------------------------------

//--------------------------------
//Emmeteur type
//--------------------------------
#define EMMETEUR_POINT			1
#define EMMETEUR_LIGNE			2
#define EMMETEUR_RECTANGLE		3
#define EMMETEUR_CUBE			4
#define EMMETEUR_CERCLE			5
#define EMMETEUR_SPIRAL			6
#define EMMETEUR_DISQUE			7
//--------------------------------

class ExCSystemeParticule : public ExCObject 
{
protected:
	//--------------------------------
	// Variable
	//--------------------------------
	std::vector<ExCParticule>			m_VecParticule;
	std::vector<ExCParticule>::iterator m_ItVecParticule;


	bool				m_State;
	bool				m_Pause;
	
	float				m_TimeLastParticule;
	char				*m_ParticuleSystemeName;

	//pram for emmeteur
	float				m_EmissionRate;
	int					m_MaxParticule;
	int					m_TypeEmmeteur;
	ExCVec3D			m_P1;//use for point
	ExCVec3D			m_P2;//use for line

	float				m_rayon;
	int					m_angle;
	int					m_vitesseangle;

	
	
	//struct for bmp
	GLuint				m_Texture;
	struct Image {
		unsigned long sizeX;
		unsigned long sizeY;
		char *data;
        };
	//Max and min value for particule
	int				m_Type;
	int				m_MaxLifeSpan;
	int				m_MinLifeSpan;
	float			m_MaxSize;
	float			m_MinSize;
	int				m_MaxWeight;
	int				m_MinWeight;
	int				m_MaxColorR;
	int				m_MinColorR;
	int				m_MaxColorG;
	int				m_MinColorG;
	int				m_MaxColorB;
	int				m_MinColorB;
	int				m_MaxBlending;
	int				m_MinBlending;
	ExCVec3D		m_MaxVelocity;
	ExCVec3D		m_MinVelocity;
	ExCVec3D		m_MaxAcceleration;
	ExCVec3D		m_MinAcceleration;
	ExCVec3D		m_MaxGravity;
	ExCVec3D		m_MinGravity;
	
public:
	ExManagerTexture	*ManagerTexture;
	void (*WriteToConsol)(const char *Label);
	//--------------------------------
	// Constructor // Destructor
	//--------------------------------
	ExCSystemeParticule(void);
	~ExCSystemeParticule(void);
	//--------------------------------
	// Methode
	//--------------------------------
	void Draw(void);
	void Start(void);
	void Pause(void);
	void Stop(void);

	bool LoadParticuleSysteme(const char * FileName);
	bool SaveParticuleSysteme(const char * FileName);
	bool LoadTexture(const char * name);

	inline char * GetParticuleSystemeName(void){return m_ParticuleSystemeName;}
	void SetParticuleSystemeName(char * name);

	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline bool GetParticuleSystemeState(void){return m_State;}
	inline void SetParticuleSystemeState(bool state){m_State=state;}
	
	void SetParticuleType(int type);
	void SetParticuleTexture(char *texture);

	inline void SetParticuleMaxLife(int life) {m_MaxLifeSpan=life;}
	inline int	GetParticuleMaxLife(void)	{return m_MaxLifeSpan;}
	inline void SetParticuleMinLife(int life) {m_MinLifeSpan=life;}
	inline int	GetParticuleMinLife(void)	{return m_MinLifeSpan;}

	inline void SetParticuleMaxSize(float Size) {m_MaxSize=Size;}
	inline float	GetParticuleMaxSize(void)	{return m_MaxSize;}
	inline void SetParticuleMinSize(float Size) {m_MinSize=Size;}
	inline float	GetParticuleMinSize(void)	{return m_MinSize;}

	inline void SetParticuleMaxWeight(int Weight) {m_MaxWeight=Weight;}
	inline int	GetParticuleMaxWeight(void)	{return m_MaxWeight;}
	inline void SetParticuleMinWeight(int Weight) {m_MinWeight=Weight;}
	inline int	GetParticuleMinWeight(void)	{return m_MinWeight;}
	
	inline void SetParticuleMaxColorR(int ColorR) {m_MaxColorR=ColorR;}
	inline int	GetParticuleMaxColorR(void)	{return m_MaxColorR;}
	inline void SetParticuleMinColorR(int ColorR) {m_MinColorR=ColorR;}
	inline int	GetParticuleMinColorR(void)	{return m_MinColorR;}

	inline void SetParticuleMaxColorG(int ColorG) {m_MaxColorG=ColorG;}
	inline int	GetParticuleMaxColorG(void)	{return m_MaxColorG;}
	inline void SetParticuleMinColorG(int ColorG) {m_MinColorG=ColorG;}
	inline int	GetParticuleMinColorG(void)	{return m_MinColorG;}

	inline void SetParticuleMaxColorB(int ColorB) {m_MaxColorB=ColorB;}
	inline int	GetParticuleMaxColorB(void)	{return m_MaxColorB;}
	inline void SetParticuleMinColorB(int ColorB) {m_MinColorB=ColorB;}
	inline int	GetParticuleMinColorB(void)	{return m_MinColorB;}

	inline void SetParticuleMaxBlending(int Blending) {m_MaxBlending=Blending;}
	inline int	GetParticuleMaxBlending(void)	{return m_MaxBlending;}
	inline void SetParticuleMinBlending(int Blending) {m_MinBlending=Blending;}
	inline int	GetParticuleMinBlending(void)	{return m_MinBlending;}

	inline void SetParticuleMaxVelocity(ExCVec3D Velocity) {m_MaxVelocity=Velocity;}
	inline ExCVec3D	GetParticuleMaxVelocity(void)	{return m_MaxVelocity;}
	inline void SetParticuleMinVelocity(ExCVec3D Velocity) {m_MinVelocity=Velocity;}
	inline ExCVec3D	GetParticuleMinVelocity(void)	{return m_MinVelocity;}

	inline void SetParticuleMaxAcceleration(ExCVec3D Acceleration) {m_MaxAcceleration=Acceleration;}
	inline ExCVec3D	GetParticuleMaxAcceleration(void)	{return m_MaxAcceleration;}
	inline void SetParticuleMinAcceleration(ExCVec3D Acceleration) {m_MinAcceleration=Acceleration;}
	inline ExCVec3D	GetParticuleMinAcceleration(void)	{return m_MinAcceleration;}

};

#endif // __EXSYSTEMEPARTICULE_H__

