/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCFile.h,v 1.12 2002/08/06 16:52:58 binny Exp $
 *
 */
 
#ifndef __EXCFILE_H
#define __EXCFILE_H

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include "ExDefine.h"


enum { FILE_EMPTY,
	FILE_CONSOLE,
	FILE_COMMAND, 
	FILE_SET,
	FILE_INTERFACE,
	FILE_PARTICULE,
	FILE_BATCH,
	FILE_UNKNOWN
};

enum { RO, WO, WOA, RW, RWA };

using namespace std;

class ExCFileDataAction {
	private:
		string action;
		int command;
		string param;
	public:
		ExCFileDataAction () {};
		ExCFileDataAction (string s, int c) { action = s; command = c; };
		void setAction (string s) { action = s; };		
		string getAction (void) { return action; };
		
		void setCommand (int c) { command = c; };
		int getCommand (void) { return command; };
		
		void setParam (string p) { param = p; };
		string getParam (void) { return param; };
		
		void setActionCommand (string s, int c) { action = s; command = c; };
		void setActionCommand (string s, int c, string p) { action = s; command = c; param = p; };
};

class ExCFileData {
	private:		
		int type;
		vector<ExCFileDataAction> content;
	public:
		ExCFileData () { type = FILE_EMPTY; };
		ExCFileData (int t, vector<ExCFileDataAction> s) { type = t; content = s; };
		void setType (int t) { type = t; };
		int getType (void) { return type; };
		void setContent (vector<ExCFileDataAction> s) { content = s; };
		void addElement (ExCFileDataAction s) { content.push_back (s); }
		vector<ExCFileDataAction> getContent (void) { return content; };
};

class ExCFile {
	protected:
		string filename;
		ios_base::openmode mode;
	public:
		ExCFile () {};
		ExCFile (string s) { filename = s; };
		ExCFile (string s, int m) { filename = s, setOpenMode (m); };
		virtual ~ExCFile ();
		bool open (void);
		bool close (void);
		void setOpenMode (int);
		ios_base::openmode getOpenMode (int);
		
		void setFileName (string s) { filename = s; };
		std::string getFileName (void) { return filename; };
		
		bool exist (void);
		vector<std::string> getContent (void);
		bool add (std::string);
		bool addLine (void);
};

class ExCFileReader : public ExCFile {
	private:
		ExCFileData *file_data;
	public:
		ExCFileReader () : ExCFile () { file_data = new ExCFileData; };
		ExCFileReader (string);
		ExCFileData getContent (void);
};

class ExCFileWriter : public ExCFile {
	public:
		ExCFileWriter () : ExCFile () {};
		ExCFileWriter (string);
		void setContent (ExCFileData);
};

#endif // __EXCFILE_H
