/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCOptions.h,v 1.6 2002/08/06 16:52:58 binny Exp $
 *
 */

#ifndef __EXCOPTIONS_H
#define __EXCOPTIONS_H

#include <iostream>
#include <string>
#include <vector>

#include "ExCFile.h"

#ifdef UNIX_SRC
#include <sys/stat.h>
#include <sys/types.h>
#endif

enum { 
	EXC_NORMAL = 1,
	EXC_DEBUG,
	EXC_TRACE,
	EXC_LOG,
	EXC_OPTIONS_ALL,
	EXC_OPTIONS_RELOAD };

#ifdef UNIX_SRC
#define EXNIHILO_REP_NAME "/.exnihilo"
#else
#define EXNIHILO_REP_NAME
#endif

class ExCOptions {
	private:		
		int type_of_debug;
		ExCFile *options_file;
		
		bool load (int);
		bool create_options_file (void);
	
		int resolution_x;
		int resolution_y;
		int rate;
		int depth;
		std::string fullscreen;
		std::string fps;
		
		int debug_style;
	public:
		ExCOptions ();
		//~ExCOptions ();
		bool init (void);
		bool load (void);
		bool reload (void);
	
		// for window
		int getWindowResolutionX (void) { return resolution_x; }
		int getWindowResolutionY (void) { return resolution_y; }
		int getWindowDepth (void) { return depth; }
		int getWindowRate (void) { return rate; }
		bool getWindowFullscreen (void);
		bool getWindowShowfps (void);
		bool getDebugStyle (void) { return debug_style; }
};

#endif // __EXCOPTIONS_H
