/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCTime.h,v 1.4 2002/07/05 12:50:38 binny Exp $
 *
 */

#ifndef __EXCTIME_H
#define __EXCTIME_H

#include <iostream>
#ifdef UNIX_SRC
#include <unistd.h>
#endif
#include <ctime>

class ExCTime {
	private:
#ifdef UNIX_SRC
		clock_t _start, _finish;
#endif
		time_t _real_t0, _real_t1;
		float _long_t;
	public:
		ExCTime ();
		bool start (float);
		bool stop (void);

		// using this method force the software 
		// to wait for time is finished
		bool startBlock (float);

		// this use the real time
		bool isTimePassed (float);
		bool isFinished (void);
#ifdef UNIX_SRC
		// this use clock time, not real time
		bool isClockTimePassed (float);
		bool isClockFinished (void);
#endif
};

#endif // __EXCTIME_H
