/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCTrace.h,v 1.3 2002/08/06 16:52:58 binny Exp $
 *
 */

#ifndef EXCTRACE_H__
#define EXCTRACE_H__

#include <string>
#include <iostream>
#include <fstream>

//#include "ExCOptions.h"

/*
	Traceable call stack
	Before compiling make your choice betwene
	1) NORMAL
	2) TRACE
	3) DEBUG
	4) LOG
	
	NORMAL :
		Guard and UnGard are defined as nothing use only when you 
		have finish your programe
	TRACE :
		Each function call will be show on consol and each 
		function out to
	DEBUG :
		If any exception occure you will show on consol the 
		call stack and where the programme bug ...
	LOG	:
		Same as Debug but all is redirect to log.txt
*/

#ifndef UNIX_SRC
	// under WIN32 change here
	// UNIX users use the configure script
	#define DEBUG
#endif
#define EXC throw 1;
 
//#ifndef UNIX_SRC
	#ifdef NORMAL
		#define Guard(function) 
		#define UnGuard
		#define Trace
		#define Error
	#else 
	#ifdef LOG
		static ofstream logfile("callstack.log",ios::app);\
		std::cout=logfile;
		#define Guard(function)	static char * __FUNCTION_NAME__ = #function;\
										try {
		#define UnGuard } catch (...) {\
										time_t tt;struct tm *ttb;tt = time(NULL);ttb = localtime(&tt);\
										std::cout<<"*********************CALL STACK*********************"<<std::endl;\
										std::cout<<"* Date   : "<<asctime(ttb);\
										std::cout<<"* Module : "<<__FUNCTION_NAME__<<std::endl;\
										std::cout<<"* Line   : "<<__LINE__<<std::endl;\
										std::cout<<"* File   : "<<__FILE__<<std::endl;\
										std::cout<<"* Make date : "<<__DATE__<<" "<<__TIME__<<std::endl;\
										std::cout<<"***************************************************"<<std::endl;\
										throw; }
	#elif defined DEBUG
		#define Guard(function)	static char * __FUNCTION_NAME__ = #function;\
										try {
		#define UnGuard } catch (...) {\
										time_t tt;struct tm *ttb;tt = time(NULL);ttb = localtime(&tt);\
										std::cout<<"*********************CALL STACK*********************"<<std::endl;\
										std::cout<<"* Date   : "<<asctime(ttb);\
										std::cout<<"* Module : "<<__FUNCTION_NAME__<<std::endl;\
										std::cout<<"* Line   : "<<__LINE__<<std::endl;\
										std::cout<<"* File   : "<<__FILE__<<std::endl;\
										std::cout<<"* Make date : "<<__DATE__<<" "<<__TIME__<<std::endl;\
										std::cout<<"***************************************************"<<std::endl;\
										throw; }
	#elif defined TRACE
		#ifdef UNIX_SRC
			#include <pthread.h>
			extern pthread_mutex_t mutex;
			extern int trace_level;
			#define Guard(fct) if (&mutex == NULL) pthread_mutex_init(&mutex, NULL);\
				static char* __FUNCTION_NAME__ = #fct;\
				pthread_mutex_lock (&mutex);\
				trace_level++;\
				pthread_mutex_unlock (&mutex);\
				std::cout<<">>>> " << trace_level << " Module : "<<__FUNCTION_NAME__<<std::endl;
			#define UnGuard std::cout<<"<<<< " << trace_level << " Module : "<<__FUNCTION_NAME__<<std::endl;\
				pthread_mutex_lock (&mutex);\
				trace_level--;\
				pthread_mutex_unlock (&mutex);
		#else
			#define Guard(function)	static char * __FUNCTION_NAME__ = #function;\
											std::cout<<">>>> Module : "<<__FUNCTION_NAME__<<std::endl;
			#define UnGuard					std::cout<<"<<<< Module : "<<__FUNCTION_NAME__<<std::endl;
		#endif // !UNIX_SRC
	#endif //TRACE
	
	#define Trace(why) static char * __WHY__ = #why;\
										time_t tt;struct tm *ttb;tt = time(NULL);ttb = localtime(&tt);\
										std::cout<<"***********************TRACE***********************"<<std::endl;\
										std::cout<<"* Date      : "<<asctime(ttb);\
										std::cout<<"* Module    : "<<__FUNCTION_NAME__<<std::endl;\
										std::cout<<"* Line      : "<<__LINE__<<std::endl;\
										std::cout<<"* File      : "<<__FILE__<<std::endl;\
										std::cout<<"* Make date : "<<__DATE__<<" "<<__TIME__<<std::endl;\
										std::cout<<"* Cause     : "<<__WHY__<<std::endl;\
										std::cout<<"* Error     : "<<errno<<std::endl;\
										std::cout<<"***************************************************"<<std::endl;
	
	#endif // !NORMAL
//#endif
							
#endif // EXCTRACE_H__
