/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCXMLParser.h,v 1.1 2002/08/01 19:37:49 binny Exp $
 *
 */
 
#ifndef __EXCXMLPARSER_H
#define __EXCXMLPARSER_H

#include "ExCFile.h"
#include <iostream>
#include <string>
#include <vector>

#ifdef XML_TEST

class ExCXMLAction {
	private:
		int action;
		string command;
		string sub;	
		int args;
		vector<int> iarg;
		vector<string> sarg;
	public:
		ExCXMLAction ();
		~ExCXMLAction ();
	
		void setAction (int);
		void setCommand (string);
		void setSub (string);
		void setArgs (int);
		void add (string);
		void add (int);
	
		bool isInt (void);
		bool isString (void);
	
		int getAction (void);
		string getCommand (void);
		string getSub (void);
		int getArgs (void);
		vector<int> getInt (void);
		vector<string> getString (void);
		void reset (void);
};

class ExCXMLFileParse {
	private:
		vector<ExCXMLAction> _action;
		string type;
	public:
		ExCXMLFileParse ();
		~ExCXMLFileParse ();
	
		void add (ExCXMLAction);
		void setType (string);
		string getType (void);
		vector<ExCXMLAction> getParsing (void);
};

class ExCXMLParser {
	private:
		ExCXMLFileParse action_parsing;
	public:
		ExCXMLParser ();
		~ExCXMLParser ();
	
		ExCXMLFileParse parse (ExCFileReader*);		
};

#endif // __EXCXMLPARSER_H

#endif // XML_TEST
