/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: Main.cpp,v 1.27 2002/08/06 16:52:58 binny Exp $
 *
 */

#include "Main.h"

int fen;
int main(int argc, char* argv[])
{
Guard(int main(...))
	Consol = new std::ostrstream;
	// on load les options
	ExCOptions *options = new ExCOptions;
	options->init ();
	
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGB|GLUT_DEPTH);

	ManagerWindow			= new ExManagerWindow;
	ManagerConsole			= new ExManagerConsole;
	ManagerOutPut			= new ExManagerOutput;
	ManagerTexture			= new ExManagerTexture;
	ManagerPVS	   			= new ExManagerPVS;
	ManagerCollision		= new ExManagerCollision;
	ManagerEntite			= new ExManagerEntite;
	ManagerCam				= new ExManagerCam;
	ManagerMenu				= new ExManagerMenu;
	ManagerInterface		= new ExManagerInterface;
	ManagerMap				= new ExManagerMap;
	ManagerCommand			= new ExManagerCommand;
	ManagerParticuleSystem	= new ExManagerParticuleSystem;
	ManagerGizmo			= new ExManagerGizmo;
	ManagerLight			= new ExManagerLight;
	ManagerFog				= new ExManagerFog;
	ManagerAnimation		= new ExManagerAnimation;
	ManagerInputGLUT		= new ExManagerInputGLUT;
	ManagerId				= new ExManagerId;
	ManagerSound			= new ExManagerSound;
	ManagerSpirit			= new ExManagerSpirit;

	SetManagerLink();
	
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Starting ExNihilo Engine              *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	ManagerWindow->Create (options->getWindowResolutionX(), options->getWindowResolutionY (), 200, 200, argv[0]);
	ManagerWindow->SetFpsState (options->getWindowShowfps ());
	InitGlExtension();
	InitManager();
	ManagerInputGLUT->CheckInput();
	ManagerInputGLUT->DisplayAviableInput();
	ManagerSound->DisplayAviableInput();
	SetGlutCallBack();
	glutSetKeyRepeat(GLUT_KEY_REPEAT_ON);
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Lauching Engine                       *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	
	for(int i = 1; i < argc; i++) {
		if(argv[i]) {
			//std::cout<<argv[i]<<std::endl;
			ManagerCommand->LoadFile(argv[i]);
		}
	}
	glutMainLoop();
UnGuard
return 0;
}

void RoutingtoConsole(const char *Label)
{
	Guard(void RoutingtoConsole(const char *Label))
		ManagerConsole->Write(Label);
	UnGuard
}

void SetManagerLink(void)
{
Guard(void SetManagerLink(void))
	ManagerConsole->Consol=Consol;
	ManagerWindow->Consol=Consol;
	ManagerOutPut->Consol=Consol;
	ManagerTexture->Consol=Consol;
	ManagerPVS->Consol=Consol;
	ManagerCollision->Consol=Consol;
	ManagerEntite->Consol=Consol;
	ManagerCam->Consol=Consol;
	ManagerMenu->Consol=Consol;
	ManagerInterface->Consol=Consol;
	ManagerMap->Consol=Consol;
    ManagerParticuleSystem->Consol=Consol;
	ManagerGizmo->Consol=Consol;
	ManagerLight->Consol=Consol;
	ManagerFog->Consol=Consol;
	ManagerAnimation->Consol=Consol;
	ManagerInputGLUT->Consol=Consol;
	ManagerId->Consol=Consol;
	ManagerSpirit->Consol=Consol;
	ManagerSound->Consol=Consol;
	ManagerCommand->Consol=Consol;

	ManagerWindow->WriteToConsol=&RoutingtoConsole;
	ManagerConsole->WriteToConsol=&RoutingtoConsole;
	ManagerOutPut->WriteToConsol=&RoutingtoConsole;
	ManagerTexture->WriteToConsol=&RoutingtoConsole;
	ManagerPVS->WriteToConsol=&RoutingtoConsole;
	ManagerCollision->WriteToConsol=&RoutingtoConsole;
	ManagerEntite->WriteToConsol=&RoutingtoConsole;
	ManagerCam->WriteToConsol=&RoutingtoConsole;
	ManagerMenu->WriteToConsol=&RoutingtoConsole;
	ManagerInterface->WriteToConsol=&RoutingtoConsole;
	ManagerMap->WriteToConsol=&RoutingtoConsole;
	ManagerCommand->WriteToConsol=&RoutingtoConsole;
	ManagerParticuleSystem->WriteToConsol=&RoutingtoConsole;
	ManagerGizmo->WriteToConsol=&RoutingtoConsole;
	ManagerLight->WriteToConsol=&RoutingtoConsole;
	ManagerFog->WriteToConsol=&RoutingtoConsole;
	ManagerAnimation->WriteToConsol=&RoutingtoConsole;
	ManagerInputGLUT->WriteToConsol=&RoutingtoConsole;
	ManagerId->WriteToConsol=&RoutingtoConsole;
	ManagerSpirit->WriteToConsol=&RoutingtoConsole;
	ManagerSound->WriteToConsol=&RoutingtoConsole;

	ManagerWindow->SetManagerId	(ManagerId	);
	ManagerTexture->SetManagerId	(ManagerId	);
	ManagerPVS->SetManagerId	(ManagerId	);
	ManagerCollision->SetManagerId	(ManagerId	);
	ManagerEntite->SetManagerId	(ManagerId	);
	ManagerCam->SetManagerId	(ManagerId	);
	ManagerMenu->SetManagerId	(ManagerId	);
	ManagerInterface->SetManagerId	(ManagerId	);
	ManagerMap->SetManagerId	(ManagerId	);
	ManagerCommand->SetManagerId	(ManagerId	);
	ManagerGizmo->SetManagerId	(ManagerId	);
	ManagerLight->SetManagerId	(ManagerId	);
	ManagerFog->SetManagerId	(ManagerId	);
	ManagerAnimation->SetManagerId	(ManagerId	);
	ManagerSpirit->SetManagerId	(ManagerId	);
	ManagerSound->SetManagerId	(ManagerId	);

	ManagerInputGLUT->SetManagerCommand(ManagerCommand);

	ManagerCommand->SetManagerAnim(ManagerAnimation);
	ManagerCommand->SetManagerCam(ManagerCam);
	ManagerCommand->SetManagerCollision(ManagerCollision);
	ManagerCommand->SetManagerEntite(ManagerEntite);
	ManagerCommand->SetManagerFog(ManagerFog);
	ManagerCommand->SetManagerGizmo(ManagerGizmo);
	ManagerCommand->SetManagerLight(ManagerLight);
	ManagerCommand->SetManagerMap(ManagerMap);
	ManagerCommand->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerCommand->SetManagerPVS(ManagerPVS);
	ManagerCommand->SetManagerTexture(ManagerTexture);
	ManagerCommand->SetManagerWindow(ManagerWindow);
 	ManagerCommand->SetManagerGizmo(ManagerGizmo);
	ManagerCommand->SetManagerMenu(ManagerMenu);
	ManagerCommand->SetManagerInterface(ManagerInterface);
	ManagerCommand->SetManagerConsole(ManagerConsole);
	ManagerCommand->SetManagerSound(ManagerSound);
	ManagerCommand->SetManagerSpirit(ManagerSpirit);

	ManagerMap->SetManagerTexture(ManagerTexture);
    
	ManagerEntite->SetManagerCollision(ManagerCollision);
	ManagerEntite->SetManagerPVS(ManagerPVS);
	ManagerEntite->SetManagerTexture(ManagerTexture);

	ManagerParticuleSystem->SetManagerCollision(ManagerCollision);
	ManagerParticuleSystem->SetManagerPVS(ManagerPVS);
	ManagerParticuleSystem->SetManagerTexture(ManagerTexture);

	ManagerGizmo->SetManagerCollision(ManagerCollision);
	ManagerGizmo->SetManagerPVS(ManagerPVS);

	ManagerLight->SetManagerCollision(ManagerCollision);
	ManagerLight->SetManagerPVS(ManagerPVS);

	ManagerCam->SetManagerCollision(ManagerCollision);
	ManagerCam->SetManagerPVS(ManagerPVS);

	ManagerOutPut->SetManagerWindow(ManagerWindow);
	ManagerOutPut->SetManagerPVS(ManagerPVS);
	ManagerOutPut->SetManagerCam(ManagerCam);
	ManagerOutPut->SetManagerAnim(ManagerAnimation);
	ManagerOutPut->SetManagerCollision(ManagerCollision);
	ManagerOutPut->SetManagerFog(ManagerFog);
	ManagerOutPut->SetManagerCommand(ManagerCommand);
	ManagerOutPut->SetManagerMenu(ManagerMenu);
	ManagerOutPut->SetManagerInterface(ManagerInterface);
	ManagerOutPut->SetManagerConsole(ManagerConsole);
	ManagerOutPut->SetManagerMap(ManagerMap);
	
	ManagerInterface->SetManagerTexture(ManagerTexture);
	ManagerInterface->SetManagerWindow(ManagerWindow);

	ManagerConsole->SetManagerWindow(ManagerWindow);
	ManagerConsole->SetManagerTexture(ManagerTexture);

	//------------------------
	//Recording to pvs
	//------------------------
	ManagerEntite->RecordToManagerPVS();
	ManagerParticuleSystem->RecordToManagerPVS();
UnGuard
}

void InitGlExtension(void)
{
Guard(void InitGlExtension(void))
	char *extList = (char *) glGetString(GL_EXTENSIONS);
	
	//checking for compiled vertex array
	if(extList && strstr(extList,"GL_EXT_compiled_vertex_array"))
	{
	#ifdef UNIX_SRC
	
	#else
		glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC) wglGetProcAddress("glLockArraysEXT");
		glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC) wglGetProcAddress("glUnLockArraysEXT");
	#endif
	}

UnGuard
}

void InitManager(void)
{
Guard(void InitManager(void))
	ManagerWindow->GlutCallBack=&SetGlutCallBack;
	ManagerOutPut->Init();
	ManagerEntite->Init();
	ManagerCam->Init();
	ManagerCommand->Init();
	ManagerConsole->Init();
	ManagerTexture->Init();
	ManagerSound->Init();
	
UnGuard
}

void SetGlutCallBack(void)
{
	//------------------------------------------------
	//Adressage des Callbacks Keyboard
	//------------------------------------------------	
	if(ManagerInputGLUT->IsKeyboard())
	{	
		glutKeyboardFunc(keyboard);
		glutKeyboardUpFunc(keyboardup);
		glutSpecialFunc(spekeyboard);
		glutSpecialUpFunc(spekeyboardup);
	}else
	{
		glutKeyboardFunc(NULL);
		glutKeyboardUpFunc(NULL);
		glutSpecialFunc(NULL);
		glutSpecialUpFunc(NULL);
	}
	//------------------------------------------------
	//Adressage des Callbacks Mouse
	//------------------------------------------------	
	if(ManagerInputGLUT->IsMouse())
	{
		glutMouseFunc(Mouse);
		glutEntryFunc(Focus);
		glutMotionFunc(MotionFunc);
		glutPassiveMotionFunc(PassiveMotionFunc);
	}
	else
	{
		glutMouseFunc(NULL);
		glutEntryFunc(NULL);
		glutMotionFunc(NULL);
		glutPassiveMotionFunc(NULL);
	}
	//------------------------------------------------
	//Adressage des Callbacks Joystick
	//------------------------------------------------	
	if(ManagerInputGLUT->IsJoystick())
	{
	}
	else
	{
	}
	//------------------------------------------------
	//Adressage des Callbacks SpaceBall
	//------------------------------------------------	
	if(ManagerInputGLUT->IsSpaceBall())
	{
		glutSpaceballMotionFunc(SpaceballMotionFunc);
		glutSpaceballRotateFunc(SpaceballRotateFunc);
	}
	else
	{
		glutSpaceballRotateFunc(NULL);
		glutSpaceballMotionFunc(NULL);
	}
	//------------------------------------------------
	//Adressage des Callbacks Tablet
	//------------------------------------------------	
	if(ManagerInputGLUT->IsTablet())
	{
		glutTabletMotionFunc(TabletMotionFunc);
		glutTabletButtonFunc(TabletButtonFunc);
	}
	else
	{
		glutTabletMotionFunc(NULL);
		glutTabletButtonFunc(NULL);
	}
	//------------------------------------------------
	//Adressage des Callbacks Affichage
	//------------------------------------------------	
	glutDisplayFunc(display);
	glutIdleFunc(display);	
	glutReshapeFunc(reshape);
	//------------------------------------------------
	//List affichage
	//------------------------------------------------
	ManagerConsole->Init();
	ManagerEntite->MakeGlListForAll();
	InitBasicObjectList();
	ManagerOutPut->Init();
	ManagerInterface->Reset();
	ManagerInterface->init();
	
}

void keyboard(unsigned char key,int x,int y){ManagerInputGLUT->Key(key,x,y);}
void keyboardup(unsigned char key, int x, int y){ManagerInputGLUT->KeyUp(key,x,y);}
void spekeyboard(int key,int x,int y){ManagerInputGLUT->KeySpe(key,x,y);}	
void spekeyboardup(int key, int x, int y){ManagerInputGLUT->KeySpeUp(key,x,y);}
void Mouse(int button, int state, int x, int y){ManagerInputGLUT->Mouse(button,state,x,y);}
void Focus(int state){ManagerInputGLUT->Focus(state);}
void MotionFunc(int x, int y){ManagerInputGLUT->MouseMotion(x,y);}
void PassiveMotionFunc(int x, int y){ManagerInputGLUT->MousePassiveMotion(x,y);}
void SpaceballMotionFunc(int x, int y, int z){ManagerInputGLUT->SpaceballMotion(x,y,z);} 
void SpaceballRotateFunc(int x, int y, int z){ManagerInputGLUT->SpaceballRotate(x,y,z);}
void TabletMotionFunc(int x, int y){ManagerInputGLUT->TabletMotion(x,y);} 
void TabletButtonFunc(int button, int state, int x, int y)	{ManagerInputGLUT->TabletButton(button,state,x,y);} 
void display(void){ManagerOutPut->DrawScene();}
void reshape(int w,int h){ManagerOutPut->Reshape(w,h);}



