/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: Main.h,v 1.8 2002/08/01 18:45:57 data Exp $
 *
 */

#ifndef __MAIN_H__
#define __MAIN_H__
//--------------------------------------------------------------------
//Includes
//--------------------------------------------------------------------

#include <math.h>

#include "ExDefine.h"
#include "ExMath.h"
#include "ExManagerWindow.h"
#include "ExManagerConsole.h"
#include "ExManagerOutput.h"
#include "ExManagerTexture.h"
#include "ExManagerPVS.h"
#include "ExManagerCollision.h"
#include "ExManagerEntite.h"
#include "ExManagerCam.h"
#include "ExManagerMenu.h"
#include "ExManagerInterface.h"
#include "ExManagerMap.h"
#include "ExManagerCommand.h"
#include "ExManagerParticuleSystem.h"
#include "ExManagerGizmo.h"
#include "ExManagerLight.h"
#include "ExManagerFog.h"
#include "ExManagerAnimation.h"
#include "ExManagerId.h"
#include "ExManagerSound.h"
#include "ExManagerSpirit.h"
#include "ExManagerInputGLUT.h"
#include "ExPredefinedObject.h"
#include "ExCFile.h"
#include "ExCOptions.h"

//--------------------------------------------------------------------
//fonctions for glut call back
//--------------------------------------------------------------------
void display(void);								
void reshape(int w, int h) ;					
void keyboard(unsigned char key,int x,int y);	
void keyboardup(unsigned char key, int x, int y);
void spekeyboard(int key,int x,int y);			
void spekeyboardup(int key, int x, int y) ;
void Mouse(int button, int state, int x, int y);
void MotionFunc(int x, int y); 
void PassiveMotionFunc(int x, int y); 
void SpaceballMotionFunc(int x, int y, int z); 
void SpaceballRotateFunc(int x, int y, int z);
void TabletMotionFunc(int x, int y);
void TabletButtonFunc(int button, int state, int x, int y);
void Focus(int state);
void DrawGrid(void);
void SetGlutCallBack(void);
void SetManagerLink(void);
void InitManager(void);
void InitGlExtension(void);
void RoutingtoConsole(const char *Label);
//--------------------------------------------------------------------
// Variables
//--------------------------------------------------------------------
ExManagerWindow				*ManagerWindow;
ExManagerConsole			*ManagerConsole;
ExManagerOutput				*ManagerOutPut;
ExManagerTexture			*ManagerTexture;
ExManagerPVS				*ManagerPVS;
ExManagerCollision			*ManagerCollision;
ExManagerEntite				*ManagerEntite;
ExManagerCam				*ManagerCam;
ExManagerMenu				*ManagerMenu;
ExManagerInterface			*ManagerInterface;
ExManagerMap				*ManagerMap;
ExManagerCommand			*ManagerCommand;
ExManagerParticuleSystem	*ManagerParticuleSystem;
ExManagerGizmo				*ManagerGizmo;
ExManagerLight				*ManagerLight;
ExManagerFog				*ManagerFog;
ExManagerAnimation			*ManagerAnimation;
ExManagerInputGLUT			*ManagerInputGLUT;
ExManagerId					*ManagerId;
ExManagerSpirit				*ManagerSpirit;
ExManagerSound				*ManagerSound;
#endif//__MAIN_H__
