/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCam.cpp,v 1.4 2002/07/10 11:09:46 data Exp $
 *
 */
#include "ExManagerCam.h"

ExManagerCam::ExManagerCam(void)
{
Guard(ExManagerCam::ExManagerCam(void))
	m_CurrentCam=0;
	m_multiview=false;
	itcount=0;
UnGuard
}


ExManagerCam::~ExManagerCam(void)
{
Guard(ExManagerCam::~ExManagerCam(void))
UnGuard
}

ExCCamera *  ExManagerCam::GetCurrentCam(void)
{
Guard(ExCCamera *  ExManagerCam::GetCurrentCam(void))
	int i=0;
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++,i++)
	{
		if(m_ItVecCamera->GetId()==m_CurrentCam)
		{
			return &m_VecCamera.at(i);
		}
	}
UnGuard
return NULL;
}

void  ExManagerCam::NextCam(void)
{
Guard(void  ExManagerCam::NextCam(void))
	int i=0;
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++,i++)
	{
		if(m_ItVecCamera->GetId()==m_CurrentCam)
		{
			m_ItVecCamera++;
			if(m_ItVecCamera==m_VecCamera.end())
			{
				m_ItVecCamera=m_VecCamera.begin();
			}
			m_CurrentCam=m_ItVecCamera->GetId();
		}
	}
UnGuard
}

void  ExManagerCam::PrevCam(void)
{
Guard(void  ExManagerCam::PrevCam(void))
	int i=0;
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++,i++)
	{
		if(m_ItVecCamera->GetId()==m_CurrentCam)
		{
			if(m_ItVecCamera==m_VecCamera.begin())
			{
				m_ItVecCamera=m_VecCamera.end()-1;
			}else
			{
				m_ItVecCamera--;
			}
			m_CurrentCam=m_ItVecCamera->GetId();
		}
	}
UnGuard
}

void  ExManagerCam::SetCurrentCam(ExId Id)
{
Guard(void  ExManagerCam::SetCurrentCam(ExId Id))
	//checking if id exist before !!!
	m_CurrentCam=Id;
UnGuard
}


void  ExManagerCam::Reset(void)
{
Guard(void  ExManagerCam::Reset(void))
	m_VecCamera.clear();
	Init();
	//remove all from id
UnGuard
}

bool  ExManagerCam::Init(char * FileName)
{
Guard(bool  ExManagerCam::Init(char * FileName))
	//openf file and load object
	return true;
UnGuard
}

void  ExManagerCam::Init(void)
{
Guard(void  ExManagerCam::Init(void))
	m_MultSlot1=NewObject();
	m_MultSlot2=NewObject();
	m_MultSlot3=NewObject();
	m_MultSlot4=NewObject();
UnGuard
}

ExId  ExManagerCam::NewObject(void)
{
Guard(ExId  ExManagerCam::NewObject(void))
	char *Name;	
	ExCCamera Camera1;
	Name= new char[strlen("CAMERA ")+3];
	sprintf(Name,"CAMERA %d",m_VecCamera.size()+1);
	Camera1.SetIdName(ManagerId->GetNewIdName(Name));
	Camera1.SetPosition(0.0f,2.0f,0.0f);
	m_VecCamera.push_back(Camera1);
	m_CurrentCam=Camera1.GetId();
	return m_CurrentCam;
UnGuard
}

ExId  ExManagerCam::Add(ExCCamera Object)
{
Guard(ExId ExManagerCam::Add(ExCCamera Object))
	return m_CurrentCam;
UnGuard
}



ExCCamera * ExManagerCam::Get(char * Name)
{
Guard(ExCCamera * ExManagerCam::Get(char * Name))
	int i=0;
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++,i++)
	{
		if(strcmp(m_ItVecCamera->GetName(),Name)==0)
		{
			return &m_VecCamera.at(i);
		}
	}
	return NULL;
UnGuard
}


ExCCamera * ExManagerCam::Get(ExId Id)
{
Guard(std::vector<ExCCamera>::iterator ExManagerCam::Get(ExId Id))
	int i=0;
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++,i++)
	{
		if(m_ItVecCamera->GetId()==Id)
		{
			return &m_VecCamera.at(i);
		}
	}
	return NULL;	
UnGuard
}




bool  ExManagerCam::Remove(ExId Id)
{
Guard(bool ExManagerCam::Remove(ExId Id))
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++)
	{
		if(m_ItVecCamera->GetId()==Id)
		{
			m_VecCamera.erase(m_ItVecCamera);
			return true;
		}
	}
	return false;
UnGuard
}


ExId  ExManagerCam::GetIdByName(char *Name)
{
Guard(ExId ExManagerCam::GetIdByName(char *Name))
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++)
	{
		if(strcmp(m_ItVecCamera->GetName(),Name)==0)
		{
			return m_ItVecCamera->GetId();
		}
	}
	return -1;
UnGuard
}


char * ExManagerCam::GetNameById(ExId Id)
{
Guard(char * ExManagerCam::GetNameById(ExId Id))
	for(m_ItVecCamera=m_VecCamera.begin();m_ItVecCamera!=m_VecCamera.end();m_ItVecCamera++)
	{
		if(m_ItVecCamera->GetId()==Id)
		{
			return m_ItVecCamera->GetName();
		}
	}
	return NULL;
UnGuard
}

void ExManagerCam::Draw(int x,int y)
{
Guard(void ExManagerCam::Draw(int x,int y))
	if(!m_multiview)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glViewport(0,0,x,y);
		gluPerspective(GetCurrentCam()->GetZoom(),
			(1.0f *x/y),
			GetCurrentCam()->GetClipNear(),
			GetCurrentCam()->GetClipFar());
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		GetCurrentCam()->Draw();
	}else
	{
		int width = glutGet(GLUT_WINDOW_WIDTH);
		int height = glutGet(GLUT_WINDOW_HEIGHT);
		width = (width+1)/2;
		height = (height+1)/2;
		bool perspective=false;
		float ratio = (float)width/height;
		switch(itcount)
		{
		case 0:
			glViewport(0, 0, width, height);
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			gluOrtho2D(0, width, 0, height);
			glMatrixMode(GL_MODELVIEW);
			//glLoadIdentity();
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glViewport(0, 0, width, height);  
			glScissor(0, 0, width, height);

			glMatrixMode(GL_PROJECTION);
			//glLoadIdentity();
			if (perspective)
			gluPerspective(60, ratio, 1, 256);
			else 
			glOrtho(-ratio, ratio, -ratio, ratio, 1, 256);
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			Get(m_MultSlot1)->Draw();
            break;
		case 1:
			glViewport(width, 0, width, height); 
			glScissor(width, 0, width, height);
			
			glMatrixMode(GL_PROJECTION);
			//glLoadIdentity();
			if (perspective)
			gluPerspective(60, ratio, 1, 256);
			else 
			glOrtho(-ratio, ratio, -ratio, ratio, 1, 256);
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			Get(m_MultSlot2)->Draw();
			break;
		case 2:
			glViewport(0, height, width, height); 
			glScissor(0, height, width, height);
			
			glMatrixMode(GL_PROJECTION);
			//glLoadIdentity();
			if (perspective)
			gluPerspective(60, ratio, 1, 256);
			else 
			glOrtho(-ratio, ratio, -ratio, ratio, 1, 256);
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			Get(m_MultSlot3)->Draw();
			break;
		case 3:
			glViewport(width, height, width, height); 
			glScissor(width, height, width, height);
			
			glMatrixMode(GL_PROJECTION);
			//glLoadIdentity();
			if (perspective)
			gluPerspective(60, ratio, 1, 256);
			else 
			glOrtho(-ratio, ratio, -ratio, ratio, 1, 256);
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			Get(m_MultSlot4)->Draw();
			break;
		}
	itcount++;
	}
UnGuard
}

