/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCommand.cpp,v 1.33 2002/08/02 18:55:14 data Exp $
 *
 */

#include "ExManagerCommand.h"

ExManagerCommand::ExManagerCommand(void)
{
	LogCommand = true;
	#ifdef UNIX_SRC
	logfilecommand.open("/tmp/logCommand.txt",ios::out);
	#else
	logfilecommand.open("logCommand.txt",ios::out);
	#endif
}

ExManagerCommand::~ExManagerCommand(void)
{
}

bool ExManagerCommand::LoadCommandFile(const char *FileName)
{
Guard(bool ExManagerCommand::LoadCommandFile(const char *FileName))
	char buffer[255];
	
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Command/%s", FileName);
#else
	sprintf(buffer, "../Data/Command/%s",FileName);
#endif
    
	ExCFileReader my_file (buffer);
	if (! my_file.exist()) 
	{
		*Consol<<"File not found: "<<buffer<<std::endl;
		return false;
	} else 
	{
		*Consol<<"Loading Command File: "<<FileName<<std::endl;	
		ExCFileData _data = my_file.getContent();
		
		if (_data.getType() != FILE_COMMAND) 
		{
			*Consol<<FileName<<" is not a valide command file"<<std::endl;
			return false;
		} else 
		{
			vector<ExCFileDataAction> dd = _data.getContent();
			vector<ExCFileDataAction>::iterator i = dd.begin ();
			ExCFileDataAction f;
			while (i != dd.end ()) 
			{
				f = *i++;
				AddCommandAction (f);
			}
		}
		return true;
	}
	
UnGuard
}


void ExManagerCommand::InputCommand(int command)
{
Guard(void ExManagerCommand::InputCommand(int command))
	SAction com;
	//cout<<"command :"<<command<<endl;
	//1 check if menu ,console ,interface,or game;
	if(ManagerWindow->GetConsoleState()) {
		com=ManagerConsole->InputCommand(command,m_MousePosX,m_MousePosY);
		//std::cout<<"Action :"<<com.m_Action<<" Param :"<<com.m_Param<<std::endl;
		AddAction(com);
	} else if(ManagerWindow->GetMenuState()) {
		//ProcessCommand(ManagerMenu->InputCommand());
	} else {
		ProcessCommand(command);
	}
	if(ManagerWindow->GetInterfaceState()) {
		com=ManagerInterface->InputCommand(command,m_MousePosX,m_MousePosY);
		//cout<<"Action :"<<com.m_Action<<" Param :"<<com.m_Param<<endl;
		AddAction(com);
	}
UnGuard
}

void ExManagerCommand::ProcessCommand(int command)
{
Guard(void ExManagerCommand::ProcessCommand(int command))
	//cout<<"Process command :"<<command<<endl;
	for(m_ItVecCommand=m_VecCommand.begin();m_ItVecCommand!=m_VecCommand.end();m_ItVecCommand++)
	{
		if(m_ItVecCommand->first==command)
		{
			AddAction(m_ItVecCommand->second);
		}
	}
UnGuard
}

void ExManagerCommand::AddAction(SAction action)
{
Guard(void ExManagerCommand::AddAction(SAction action))	
	//cout<<"Add Action"<<action<<endl;
	if(action.m_Action!=NOTHING)
	{
		m_VecAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::AddNewAction(SAction action)
{
Guard(void ExManagerCommand::AddAction(SAction action))	
	//cout<<"Add Action"<<action<<endl;
	if(action.m_Action!=NOTHING)
	{
		m_VecTempAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::RemoveRepAction(SAction action)
{
Guard(void ExManagerCommand::RemoveRepAction(SAction action))	
	int i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		if(m_VecRepAction.at(i).m_Action==action.m_Action)
		{
			m_VecRepAction.erase(m_ItVecRepAction);	break;
		}
	}
UnGuard
}

void ExManagerCommand::AddRepAction(SAction action)
{
Guard(void ExManagerCommand::AddRepAction(SAction action))	
	bool already=false;
	int i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		if(m_VecRepAction.at(i).m_Action==action.m_Action)
		{
			already=true;
		}
	}  
	if(!already)
	{  
		m_VecRepAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::ApplyAction(void)
{
Guard(void ExManagerCommand::ApplyAction(void))
	int i;
	std::vector<SAction>			TmpVecAction;
	for(m_ItVecAction=m_VecAction.begin();m_ItVecAction!=m_VecAction.end();m_ItVecAction++,i++)
	{
		//cout<<"Aplly Action :"<<m_VecAction.at(i)<<endl;
		if(!ProcessAction(*m_ItVecAction))
		{
			AddNewAction(*m_ItVecAction);
		}
	}
	
	//Remove executed action
	/*for(m_ItVecAction=m_VecAction.begin();m_ItVecAction!=m_VecAction.end();m_ItVecAction++)
	{
		
		if(!m_ItVecAction->AllActionDone())
		{
			TmpVecAction.push_back(*m_ItVecAction);
		}else
		{
			std::cout<<"action not done :"<<m_ItVecAction->m_Action<<std::endl;
		}
	}*/
	m_VecAction.clear();
	//m_VecAction=TmpVecAction;
	for(i=0; (unsigned)i<m_VecTempAction.size();i++)
	{
		AddAction(m_VecTempAction.at(i));
	}
	m_VecTempAction.clear();
	i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		ProcessAction(m_VecRepAction.at(i));
	}
	
UnGuard
}

void ExManagerCommand::AddCommandAction (ExCFileDataAction e) {
Guard(void ExManagerCommand::AddCommandAction(ExCFileDataAction e))
	CommandAction ComAct;
	ComAct.first = atoi (e.getAction ().data());
	ComAct.second.m_Action = e.getCommand ();
	ComAct.second.m_Param = new char [e.getParam ().length()];
	sprintf (ComAct.second.m_Param, "%s", e.getParam().data());
	m_VecCommand.push_back (ComAct);
UnGuard
}

void ExManagerCommand::AddCommandAction(int command,SAction action)
{
Guard(void ExManagerCommand::AddCommandAction(int command,SAction action))
	CommandAction ComAct;	
	ComAct.first=command;
	ComAct.second.m_Action=action.m_Action;
	ComAct.second.m_Param= new char[strlen(action.m_Param)];
	sprintf(ComAct.second.m_Param,"%s",action.m_Param);
	m_VecCommand.push_back(ComAct);
UnGuard
}

void ExManagerCommand::AddCommandAction(CommandAction ComAct)
{
Guard(void ExManagerCommand::AddCommandAction(CommandAction ComAct))
	m_VecCommand.push_back(ComAct);
UnGuard
}

void ExManagerCommand::AddCommandAction(int command,int action,char *param)
{
Guard(void ExManagerCommand::AddCommandAction(int command,int action,char *param))
	CommandAction ComAct;
	ComAct.first=command;
	ComAct.second.m_Action=action;
	ComAct.second.m_Param= new char[strlen(param)];
	sprintf(ComAct.second.m_Param,"%s",param);
	m_VecCommand.push_back(ComAct);	
UnGuard
}

void ExManagerCommand::Init(void)
{
Guard(void ExManagerCommand::Init(void))
	AddCommandAction(KEYBOARD_UP_ESC,		QUIT,"NULL");
	AddCommandAction(KEYBOARD_DOWN_4,		SAction(CAMERA_CURRENT_START_ROTATEY_DOWN));
	AddCommandAction(KEYBOARD_UP_4,			SAction(CAMERA_CURRENT_STOP_ROTATEY_DOWN));
	AddCommandAction(KEYBOARD_UP_5,			SAction(CAMERA_CURRENT_INCREASE_SPEED));
	AddCommandAction(KEYBOARD_UP_0,			SAction(CAMERA_CURRENT_DECREASE_SPEED));
	AddCommandAction(KEYBOARD_DOWN_6,		SAction(CAMERA_CURRENT_START_ROTATEY_UP));
	AddCommandAction(KEYBOARD_UP_6,			SAction(CAMERA_CURRENT_STOP_ROTATEY_UP));
	AddCommandAction(KEYBOARD_DOWN_2,		SAction(CAMERA_CURRENT_START_ROTATEX_UP));
	AddCommandAction(KEYBOARD_UP_2,			SAction(CAMERA_CURRENT_STOP_ROTATEX_UP));
	AddCommandAction(KEYBOARD_DOWN_8,		SAction(CAMERA_CURRENT_START_ROTATEX_DOWN));
	AddCommandAction(KEYBOARD_UP_8,			SAction(CAMERA_CURRENT_STOP_ROTATEX_DOWN));
	AddCommandAction(KEYBOARD_DOWN_1,		SAction(CAMERA_CURRENT_START_ROTATEZ_UP));
	AddCommandAction(KEYBOARD_UP_1,			SAction(CAMERA_CURRENT_STOP_ROTATEZ_UP));
	AddCommandAction(KEYBOARD_DOWN_3,		SAction(CAMERA_CURRENT_START_ROTATEZ_DOWN));
	AddCommandAction(KEYBOARD_UP_3,			SAction(CAMERA_CURRENT_STOP_ROTATEZ_DOWN));
	AddCommandAction(KEYBOARD_UP_F1,		SAction(STAR_ALL_PARTICULESYSTEME));
	AddCommandAction(KEYBOARD_UP_F2,		SAction(PAUSE_ALL_PARTICULESYSTEME));
	AddCommandAction(KEYBOARD_UP_F3,		SAction(ENABLE_ANTIALIASING));
	AddCommandAction(KEYBOARD_UP_F4,		SAction(DISABEL_ANTIALIASING));
	AddCommandAction(KEYBOARD_UP_F5,		SAction(SET_NEXT_ENTITE_CURRENT));
	AddCommandAction(KEYBOARD_UP_F6,		SAction(SET_RENDERMODE_TEXTURES_LIGHT));
	AddCommandAction(KEYBOARD_UP_F7,		SAction(SET_RENDERMODE_TEXTURES));
	AddCommandAction(KEYBOARD_UP_F8,		SAction(SET_RENDERMODE_TRIANGLES_LIGHT));
	AddCommandAction(KEYBOARD_UP_F9,		SAction(SET_RENDERMODE_TRIANGLES));
	AddCommandAction(KEYBOARD_UP_F10,		SAction(SET_RENDERMODE_POINTS));
	AddCommandAction(KEYBOARD_UP_F11,		SAction(SET_RENDERMODE_LINES));
	AddCommandAction(KEYBOARD_UP_F12,		SAction(SET_RENDERMODE_NO));
	AddCommandAction(KEYBOARD_UP_PAGE_UP,	SAction(CONSOL_LINE_UP));
	AddCommandAction(KEYBOARD_UP_PAGE_DOWN,	SAction(CONSOL_LINE_DOWN));
	AddCommandAction(KEYBOARD_DOWN_EXP,		SAction(CONSOL_NEXT_AVIABLE_STATE));
	AddCommandAction(KEYBOARD_UP_G,			SAction(SWITCH_GRIDE));

	AddCommandAction(KEYBOARD_DOWN_U,		SAction(ENTITE_CURRENT_START_ROTATE_X_DOWN));
	AddCommandAction(KEYBOARD_UP_U,			SAction(ENTITE_CURRENT_STOP_ROTATE_X_DOWN));
	AddCommandAction(KEYBOARD_DOWN_J,		SAction(ENTITE_CURRENT_START_ROTATE_X_UP));
	AddCommandAction(KEYBOARD_UP_J,			SAction(ENTITE_CURRENT_STOP_ROTATE_X_UP));

	AddCommandAction(KEYBOARD_DOWN_Y,		SAction(ENTITE_CURRENT_START_ROTATE_Y_DOWN));
	AddCommandAction(KEYBOARD_UP_Y,			SAction(ENTITE_CURRENT_STOP_ROTATE_Y_DOWN));
	AddCommandAction(KEYBOARD_DOWN_I,		SAction(ENTITE_CURRENT_START_ROTATE_Y_UP));
	AddCommandAction(KEYBOARD_UP_I,			SAction(ENTITE_CURRENT_STOP_ROTATE_Y_UP));
	
	AddCommandAction(KEYBOARD_DOWN_H,		SAction(ENTITE_CURRENT_START_ROTATE_Z_DOWN));
	AddCommandAction(KEYBOARD_UP_H,			SAction(ENTITE_CURRENT_STOP_ROTATE_Z_DOWN));
	AddCommandAction(KEYBOARD_DOWN_K,		SAction(ENTITE_CURRENT_START_ROTATE_Z_UP));
	AddCommandAction(KEYBOARD_UP_K,			SAction(ENTITE_CURRENT_STOP_ROTATE_Z_UP));
	 

UnGuard
}

void ExManagerCommand::LoadSetOfFile(const char *FileName)
{
Guard(void ExManagerCommand::LoadSetOfFile(const char *FileName))
	char			ch;
	int				RetVal;
	int				FileSize;
	FILE			*MyFile;
	bool			endfile=false;
	//int				tmp=0; // not used
	std::string		StBuffer;
	std::string		StType;
    char			buffer[255];

#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/%s",FileName);
#else
	sprintf(buffer, "../Data/%s",FileName);
#endif
    
	MyFile=fopen (buffer,"r");
	if(!MyFile)
	{
		*Consol<<"File not found:"<<buffer<<std::endl;
	}else
	{
		*Consol<<"Loading set File :"<<FileName<<std::endl;

 		fseek(MyFile,0,SEEK_END);
		FileSize=ftell(MyFile);
		//Start of file
		fseek(MyFile,0,SEEK_SET);
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='#');
		//reading file type;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			StBuffer=StBuffer+ch;	
		}while(ch!='#');
		if(strcmp(StBuffer.data(),"set#")==0)
		{
			
			do
			{
				
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				if(StBuffer.find("end of set file") != (unsigned)-1)
				{
					endfile=true;
				}else
				{
					StType=StBuffer;
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					
					if(strcmp(StType.data(),"command")==0)
					{
						std::cout<<"Load command file :"<<StBuffer.data()<<std::endl;
						LoadCommandFile(StBuffer.data());
					}
					if(strcmp(StType.data(),"console")==0)
					{
						std::cout<<"Load console file :"<<StBuffer.data()<<std::endl;
						ManagerConsole->LoadStringActionFile(StBuffer.data());	
					}
					if(strcmp(StType.data(),"interface")==0)
					{
						std::cout<<"Load interface file :"<<StBuffer.data()<<std::endl;
						ManagerInterface->LoadInterface(StBuffer.data());	
					}
					if(strcmp(StType.data(),"modele")==0)
					{
						std::cout<<"Load asc file :"<<StBuffer.data()<<std::endl;
						ManagerEntite->LoadAsc(StBuffer.data());	
					}
					if(strcmp(StType.data(),"sound")==0)
					{
						std::cout<<"Load sound file :"<<StBuffer.data()<<std::endl;
						ManagerSound->LoadSound(StBuffer.data());	
					}
					if(strcmp(StType.data(),"set")==0)
					{
						std::cout<<"Load set file :"<<StBuffer.data()<<std::endl;
						LoadSetOfFile(StBuffer.data());	
					}
					if(strcmp(StType.data(),"exec")==0)
					{
						std::cout<<"Load set file :"<<StBuffer.data()<<std::endl;
						
						SAction action;
						action.SetParam(StBuffer.data());
						LoadExecFile(&action);	
					}
					if(strcmp(StType.data(),"map")==0)
					{
						std::cout<<"Load map file :"<<StBuffer.data()<<std::endl;
						ManagerMap->LoadMap(StBuffer.data());	
					}
					
				}
			}while(!endfile);
			fclose(MyFile);
		}else
		{
			*Consol<<FileName<<" is not a valide console file"<<std::endl;
		}
    }
UnGuard
}

bool ExManagerCommand::LoadExecFile(SAction *action)
{
Guard(bool ExManagerCommand::LoadExecFile(SAction *action))
	char			ch;
	int				RetVal;
	int				FileSize;
	FILE			*MyFile;
	bool			endfile=false;
	std::string		StBuffer;
	char			buffer[255];
	char			*FileName;
	SAction			NewActionA;
	
	FileName= new char[strlen(action->m_Param)];
	sprintf(FileName,"%s",(action->m_Param)+1);
	
	sprintf(buffer,"../Data/Command/%s",FileName);
    
	MyFile=fopen (buffer,"r");
	if(!MyFile)
	{
		*Consol<<"File not found:"<<buffer<<std::endl;
		return false;
	}else
	{
		*Consol<<"Loading Exec File :"<<FileName<<std::endl;
			
 		fseek(MyFile,0,SEEK_END);
		FileSize=ftell(MyFile);
		
		//Start of file
		fseek(MyFile,0,SEEK_SET);
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='#');
		//reading file type;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			StBuffer=StBuffer+ch;	
		}while(ch!='#');
		if(strcmp(StBuffer.data(),"exec#")==0)
		{
			do
			{
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				
				if(StBuffer.find("end of exec file")!= (unsigned)-1)
				{
					endfile=true;
				}else
				{
					std::cout<<StBuffer<<std::endl;
					//read action
					try
					{
						NewActionA.m_Action=atoi(StBuffer.data());
					}catch(...)
					{
						NewActionA.m_Action=NOTHING;	
					}
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					//read param
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					std::cout<<StBuffer<<std::endl;
                    NewActionA.SetParam(StBuffer.data());
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					//read time to execute
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					std::cout<<StBuffer<<std::endl;
					try
					{
						NewActionA.m_ExecutingLife=atof(StBuffer.data());
					}catch(...)
					{
						NewActionA.m_ExecutingLife=-1;	
					}	
					std::cout<<"time to exec"<<NewActionA.m_ExecutingLife<<std::endl;					
					
					AddNewAction(NewActionA);
				}
			}while(!endfile);
			fclose(MyFile);
			return true;
		}else
		{
			*Consol<<FileName<<" is not a valide exec file"<<std::endl;
			return false;
		}
	}
	
UnGuard
}

bool ExManagerCommand::LoadFile(const char *FileName)
{
	SAction action;
	action.SetParam(FileName);
	action.m_Action=30038;
    AddNewAction(action);
	return true;
}
//-----------------------------------------------------------
// ici taper ce que fait l action
//-----------------------------------------------------------
bool ExManagerCommand::ProcessAction(SAction action)
{
Guard(bool ExManagerCommand::ProcessAction(SAction action))
	//cout<<"Process Action :"<<action<<endl;
	char *Param;
	float ParamFloat;
	Param= new char[strlen(action.m_Param)];
	sprintf(Param,"%s",(action.m_Param)+1);
	std::string Sparam(Param);

	
	//check if is time to execute action
	double ctime;
	ctime=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);

	if(action.m_ExecutingLife<0||(double)ctime-action.m_ExecutingLife>=(action.m_StartingLife))
	{
		logfilecommand<<"Process Action :"<<action.m_Action<<" Param :"<<action.m_Param<<std::endl;
		//time to execute action
		//-------------------------------------------------
		//CONSOL ACTION
		//-------------------------------------------------
		if(action.m_Action>START_CONSOL_ACTION_MAP && action.m_Action<END_CONSOL_ACTION_MAP) 
		{
			
			switch(action.m_Action)
			{
			case CONSOL_LINE_UP:						
				ManagerConsole->LineUp();
				break;
			case CONSOL_LINE_DOWN:						
				ManagerConsole->LineDown();
				break;
            case SHOW_HALF_CONSOL:						
				if (! ManagerConsole->isConsoleMove ()) {
					ManagerConsole->ConsoleMove (true);
					ManagerConsole->SetConsoleState(HALF);
				}
				break;
			case SHOW_FULL_CONSOL:
				if (! ManagerConsole->isConsoleMove ()) {
					ManagerConsole->ConsoleMove (true);
					ManagerConsole->SetConsoleState(FULL);
				}
					
				break;
			
			case HIDE_CONSOL:	
				if (! ManagerConsole->isConsoleMove ()) {
					ManagerConsole->ConsoleMove (true);
					ManagerConsole->SetConsoleState(HIDE);
				}
				break;
			
			case CONSOL_NEXT_AVIABLE_STATE:
				switch(ManagerConsole->NextAviableState())
				{
				case HIDE:
				case FULLTOHIDE:
				case HALFTOHIDE:
					ProcessAction(HIDE_CONSOL);
                    break;
				case HALF:
				case HIDETOHALF:
				case FULLTOHALF:
					ProcessAction(SHOW_HALF_CONSOL);
					break;
				case FULL:
				case HIDETOFULL:
				case HALFTOFULL:
					ProcessAction(SHOW_FULL_CONSOL);
					break;
				}
				break;

			case SET_CONSOL_BACKGROUND_TEXURE:
				ManagerConsole->SetConsoleBackGroudTexture(Param);
				break;
			case ENABLE_CONSOL_BACKGROUND_TEXTURE:
				ManagerConsole->SetConsoleBackGroudTextureState(true);
				break;
			case DISABLE_CONSOL_BACKGROUND_TEXTURE:
				ManagerConsole->SetConsoleBackGroudTextureState(false);
				break;
			case SET_CONSOL_BACKGROUND_COLOR:

				break;
			case SET_CONSOL_BACKGROUND_COLOR_BLUE:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerConsole->SetConsoleBackGroudColorBlue(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
			case SET_CONSOL_BACKGROUND_COLOR_GREEN:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerConsole->SetConsoleBackGroudColorGreen(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
			case SET_CONSOL_BACKGROUND_COLOR_RED:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerConsole->SetConsoleBackGroudColorRed(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
			case ENABLE_CONSOL_BACKGROUND_BLENDING:
				ManagerConsole->SetConsoleBackGroudBlendingState(true);
				break;
			case DISABLE_CONSOL_BACKGROUND_BLENDING:
				ManagerConsole->SetConsoleBackGroudBlendingState(false);
				break;
			case SET_CONSOL_BACKGROUND_BLENDING:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerConsole->SetConsoleBackGroudBlending(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
			}

		}
		//-------------------------------------------------
		//BASIC ACTION
		//-------------------------------------------------
		if(action.m_Action>=START_BASIC_ACTION_MAP && action.m_Action<END_BASIC_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case NOTHING:
				break;

			case QUIT:
				exit(0);
				break;

			case SET_RENDERMODE_TEXTURES_LIGHT:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_TEXTURES_LIGHT);
				}
				break;
			
			case SET_RENDERMODE_TEXTURES:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_TEXTURES);
				}
				break;
			
			case SET_RENDERMODE_TRIANGLES_LIGHT	:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_TRIANGLES_LIGHT);
				}
				break;

			case SET_RENDERMODE_TRIANGLES:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_TRIANGLES);
				}
				break;
			
			case SET_RENDERMODE_POINTS:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_POINTS);
				}
				break;
			
			case SET_RENDERMODE_LINES:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_LINES);
				}
				break;
			
			case SET_RENDERMODE_NO:
				if(ManagerEntite->GetNumberEntite()>0)
				{
					ManagerEntite->GetCurrentEntite()->SetRenderMode(RENDER_NO);
				}
				break;

			case ENABLE_ANTIALIASING:
				ManagerWindow->SetAntialliasingState(true);
				break;

			case DISABEL_ANTIALIASING:
				ManagerWindow->SetAntialliasingState(false);
				break;

			case ENABLE_GRIDE:
				ManagerWindow->SetGrilleState(true);
				break;

			case DISABLE_GRIDE:
				ManagerWindow->SetGrilleState(false);
				break;

			case SWITCH_GRIDE:
				if(ManagerWindow->GetGrilleState())
				{
					ProcessAction(DISABLE_GRIDE);	
				}else
				{
					ProcessAction(ENABLE_GRIDE);
				}
				break;
			          		


			case SET_RESOLUTION_800_600_16:
				ManagerWindow->SetResolution(800,600);
				ManagerWindow->SetBits(16);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_800_600_24:
				ManagerWindow->SetResolution(800,600);
				ManagerWindow->SetBits(24);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;

			case SET_RESOLUTION_800_600_32:
				ManagerWindow->SetResolution(800,600);
				ManagerWindow->SetBits(32);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;

			case SET_RESOLUTION_1024_768_16:
				ManagerWindow->SetResolution(1024,768);
				ManagerWindow->SetBits(16);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_1024_768_24:
				ManagerWindow->SetResolution(1024,768);
				ManagerWindow->SetBits(24);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_1024_768_32:
				ManagerWindow->SetResolution(1024,768);
				ManagerWindow->SetBits(32);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_1600_1200_16:
				ManagerWindow->SetResolution(1600,1200);
				ManagerWindow->SetBits(16);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_1600_1200_24:
				ManagerWindow->SetResolution(1600,1200);
				ManagerWindow->SetBits(24);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			
			case SET_RESOLUTION_1600_1200_32:
				ManagerWindow->SetResolution(1600,1200);
				ManagerWindow->SetBits(32);
				ManagerWindow->SetFullScreen(true);
				ManagerWindow->Apply();
				break;
			case LOAD_FILE:
				char Buffext[255];
				memset(Buffext,0,255);
				
				std::cout<<"file to load :"<<Param<<std::endl;
           		if(Sparam.find_first_of(".",0) != (unsigned)-1)
				{
					Sparam.copy(Buffext,Sparam.size()-Sparam.find_first_of(".",0)-1,Sparam.find_first_of(".",0)+1);
					if(strcmp(Buffext,"csl")==0)
					{
						ManagerConsole->LoadStringActionFile(Param);
						break;
					}else
					if(strcmp(Buffext,"comd")==0)
					{
						LoadCommandFile(Param);
						break;
					}else
					if(strcmp(Buffext,"wav")==0||strcmp(Buffext,"mid")==0)
					{
						ManagerSound->LoadSound(Param);
						break;				
					}else
					if(strcmp(Buffext,"asc")==0
						||strcmp(Buffext,"ase")==0
						||strcmp(Buffext,"3ds")==0
						||strcmp(Buffext,"md2")==0
						||strcmp(Buffext,"md3")==0
						||strcmp(Buffext,"obj")==0)
					{
						ManagerEntite->LoadAsc(Param);
						ManagerEntite->LoadModel(Param);
						break;
					}else
					if(strcmp(Buffext,"map")==0
						||strcmp(Buffext,"bsp")==0)
					{
						ManagerMap->LoadMap(Param);
						break;
					}else
					if(strcmp(Buffext,"int")==0)
					{
						ManagerInterface->LoadInterface(Param);
						break;
					}else
					if(strcmp(Buffext,"set")==0)
					{
						LoadSetOfFile(Param);
						break;
					}else
					if(strcmp(Buffext,"exec")==0)
					{
						LoadExecFile(&action);
						break;
					}
					else
					if(strcmp(Buffext,"part")==0)
					{
						ManagerParticuleSystem->LoadParticuleSysteme(Param);
						break;
					}
				}
				*Consol<<"*------------------------------------------------------------------------------------------------*"<<std::endl;
				*Consol<<"|                                Extension file supported by Exnihilo                            |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;
				*Consol<<"|Description                 | Extension |  Status  |  Comment                                   |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;				
				*Consol<<"|Console configuration file  |  .csl     | Aviable  | Asign consol command to action             |"<<std::endl;
				*Consol<<"|Command configuration file  |  .comd    | Aviable  | Asign input (keyboard,mouse,...)to action  |"<<std::endl;
				*Consol<<"|------------------------------------------------------|-----------------------------------------|"<<std::endl;				
				*Consol<<"|ExNihilo map file           |  .map     | Aviable  | Create map file with AscToMap converter    |"<<std::endl;
				*Consol<<"|Quake map file              |  .bsp     |          |                                            |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;				
				*Consol<<"|ASC model  file             |  .asc     | Aviable  | Create a 3d model and export him to *.asc  |"<<std::endl;
				*Consol<<"|MD2 (quake 2) model  file   |  .md2     |          |                                            |"<<std::endl;
                *Consol<<"|MD3 (quake 3) model  file   |  .md3     |          |                                            |"<<std::endl;
				*Consol<<"|ASE model  file             |  .ase     |          |                                            |"<<std::endl;
				*Consol<<"|3d studio max model  file   |  .3ds     |          |                                            |"<<std::endl;
				*Consol<<"|OBJ model  file             |  .obj     |          |                                            |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;				
				*Consol<<"|Wave sound file             |  .wav     |          |                                            |"<<std::endl;
                *Consol<<"|Midi sound file             |  .mid     |          |                                            |"<<std::endl;
				*Consol<<"|Mp3 sound file              |  .mp3     |          |                                            |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;
				*Consol<<"|Particule system  file      |  .part    | Aviable  |                                            |"<<std::endl;
				*Consol<<"|Interface file              |  .int     | Aviable  |                                            |"<<std::endl;
				*Consol<<"|------------------------------------------------------------------------------------------------|"<<std::endl;				
				*Consol<<"|Groupe of file              |  .set     | Aviable  |                                            |"<<std::endl;
				*Consol<<"|Groupe of action            |  .exec    | Aviable  |                                            |"<<std::endl;
				*Consol<<"*------------------------------------------------------------------------------------------------*"<<std::endl;
				break;

			case LOAD_SET_OF_FILE:
				LoadSetOfFile(Param);
				break;

			case SHOW_NET_STAT:
				ManagerWindow->SetNetstatState(true);
				break;

			case HIDE_NET_STAT:
				ManagerWindow->SetNetstatState(false);
				break;

			case SHOW_FPS_STAT:
				ManagerWindow->SetFpsState(true);
				break;

			case HIDE_FPS_STAT:
				ManagerWindow->SetFpsState(true);
				break;

			case RESET:
				//ManagerMenu->Reset();
				ManagerId->Reset();
				ManagerPVS->Reset();
				ManagerCollision->Reset();
				ManagerAnim->Reset();
				ManagerMap->Reset();	
				ManagerFog->Reset();
				ManagerEntite->Reset();
				ManagerGizmo->Reset();
				ManagerLight->Reset();
				ManagerCam->Reset();
				//ManagerParticuleSystem->Reset();
				ManagerTexture->Reset();
				ManagerInterface->Reset();
				ManagerConsole->Reset();
				ManagerSpirit->Reset();
				ManagerSound->Reset();
				ManagerConsole->ClearConsol();
				*Consol<<"Engine reseted"<<std::endl;
				break;

			case ENABLE_MULTIVIEW:
				ManagerCam->m_multiview=true;
				break;

			case DISABLE_MULTIVIEW:
				ManagerCam->m_multiview=false;
				break;

			case LIST_TEXTURE:
				ManagerTexture->ListAllTexture();
				break;
			
			case SET_SPECIAL_EFFECT:
				try
				{
					ManagerWindow->SetSpecialEffect(atoi(Param));
				}catch(...)
				{
					ManagerWindow->SetSpecialEffect(NON_EFFECT);
				}

				break;
			default:
				*Consol<<"Can not file action in BASIC_ACTION_MAP"<<std::endl;
				break;
			}

		}

		//-------------------------------------------------
		//CAMERA ACTION
		//-------------------------------------------------
		if(action.m_Action>START_CAMERA_ACTION_MAP && action.m_Action<END_CAMERA_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case CAMERA_CURRENT_START_GOTO_TARGET:
				AddRepAction(CAMERA_CURRENT_GOTO_TARGET);
				break;
			
			case CAMERA_CURRENT_STOP_GOTO_TARGET:
				RemoveRepAction(CAMERA_CURRENT_GOTO_TARGET);
				break;
			
			case CAMERA_CURRENT_GOTO_TARGET:
				ManagerCam->GetCurrentCam()->GoToView(true);
				break;

			case CAMERA_CURRENT_START_INCREASE_SPEED:
				AddRepAction(CAMERA_CURRENT_INCREASE_SPEED);
				break;
			
			case CAMERA_CURRENT_STOP_INCREASE_SPEED:
				RemoveRepAction(CAMERA_CURRENT_INCREASE_SPEED);
				break;
			
			case CAMERA_CURRENT_INCREASE_SPEED:
				ManagerCam->GetCurrentCam()->m_speed++;
				//std::cout<<"Camera Speed"<<ManagerCam->GetCurrentCam()->m_speed<<std::endl;
				break;
			
			case CAMERA_CURRENT_START_DECREASE_SPEED:
				AddRepAction(CAMERA_CURRENT_DECREASE_SPEED);
				break;
			
			case CAMERA_CURRENT_STOP_DECREASE_SPEED:
				RemoveRepAction(CAMERA_CURRENT_DECREASE_SPEED);
				break;
			
			case CAMERA_CURRENT_DECREASE_SPEED:
				if(ManagerCam->GetCurrentCam()->m_speed>0)
				{
					ManagerCam->GetCurrentCam()->m_speed--;
				}
				//std::cout<<"Camera Speed"<<ManagerCam->GetCurrentCam()->m_speed<<std::endl;
				break;

			case CAMERA_CURRENT_FULL_STOP:
				ManagerCam->GetCurrentCam()->m_speed=0;
				//std::cout<<"Camera Speed"<<ManagerCam->GetCurrentCam()->m_speed<<std::endl;
				break;


			case CAMERA_CURRENT_START_ROTATEX_UP:
				AddRepAction(CAMERA_CURRENT_ROTATEX_UP);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEX_UP:
				RemoveRepAction(CAMERA_CURRENT_ROTATEX_UP);
				break;
			
			case CAMERA_CURRENT_ROTATEX_UP:
				ManagerCam->GetCurrentCam()->m_AngleX++;
				ManagerCam->GetCurrentCam()->m_AngleX++;
				break;
			
			case CAMERA_CURRENT_START_ROTATEX_DOWN:
				AddRepAction(CAMERA_CURRENT_ROTATEX_DOWN);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEX_DOWN:
				RemoveRepAction(CAMERA_CURRENT_ROTATEX_DOWN);
				break;
			
			case CAMERA_CURRENT_ROTATEX_DOWN:
				ManagerCam->GetCurrentCam()->m_AngleX--;
				ManagerCam->GetCurrentCam()->m_AngleX--;
				break;

			case CAMERA_CURRENT_START_ROTATEZ_UP:
				AddRepAction(CAMERA_CURRENT_ROTATEZ_UP);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEZ_UP:
				RemoveRepAction(CAMERA_CURRENT_ROTATEZ_UP);
				break;
			
			case CAMERA_CURRENT_ROTATEZ_UP:
				ManagerCam->GetCurrentCam()->m_AngleZ++;
				ManagerCam->GetCurrentCam()->m_AngleZ++;
				break;
			
			case CAMERA_CURRENT_START_ROTATEZ_DOWN:
				AddRepAction(CAMERA_CURRENT_ROTATEZ_DOWN);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEZ_DOWN:
				RemoveRepAction(CAMERA_CURRENT_ROTATEZ_DOWN);
				break;
			
			case CAMERA_CURRENT_ROTATEZ_DOWN:
				ManagerCam->GetCurrentCam()->m_AngleZ--;
				ManagerCam->GetCurrentCam()->m_AngleZ--;
				break;

			case CAMERA_CURRENT_START_ROTATEY_UP:
				AddRepAction(CAMERA_CURRENT_ROTATEY_UP);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEY_UP:
				RemoveRepAction(CAMERA_CURRENT_ROTATEY_UP);
				break;
			
			case CAMERA_CURRENT_ROTATEY_UP:
				ManagerCam->GetCurrentCam()->m_AngleY++;
				ManagerCam->GetCurrentCam()->m_AngleY++;
				break;
			
			case CAMERA_CURRENT_START_ROTATEY_DOWN:
				AddRepAction(CAMERA_CURRENT_ROTATEY_DOWN);
				break;
			
			case CAMERA_CURRENT_STOP_ROTATEY_DOWN:
				RemoveRepAction(CAMERA_CURRENT_ROTATEY_DOWN);
				break;
			
			case CAMERA_CURRENT_ROTATEY_DOWN:
				ManagerCam->GetCurrentCam()->m_AngleY--;
				ManagerCam->GetCurrentCam()->m_AngleY--;
				break;

			case CAMERA_CURRENT_ROTATEY_UP_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleY<atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleY++;
						ManagerCam->GetCurrentCam()->m_AngleY++;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.m_ExecutingLife=0.05f;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEY_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_CURRENT_ROTATEY_DOWN_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleY>atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleY--;
						ManagerCam->GetCurrentCam()->m_AngleY--;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.m_ExecutingLife=0.05f;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEY_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_CURRENT_ROTATEX_UP_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleX<atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleX++;
						ManagerCam->GetCurrentCam()->m_AngleX++;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEX_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_CURRENT_ROTATEX_DOWN_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleX>atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleX--;
						ManagerCam->GetCurrentCam()->m_AngleX--;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEX_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_CURRENT_ROTATEZ_UP_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleZ<atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleZ++;
						ManagerCam->GetCurrentCam()->m_AngleZ++;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEZ_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_CURRENT_ROTATEZ_DOWN_TO:
					if(ManagerCam->GetCurrentCam()->m_AngleZ>atoi(Param))
					{
						ManagerCam->GetCurrentCam()->m_AngleZ--;
						ManagerCam->GetCurrentCam()->m_AngleZ--;
						char *nparam;
						nparam= new char[strlen(Param)+1];
						sprintf(nparam," %s",Param);
						SAction action;
						action.SetParam(nparam);
						action.m_Action=CAMERA_CURRENT_ROTATEZ_UP_TO;
						AddNewAction(action);
					}
				break;

			case CAMERA_NEXT_CAM:
				ManagerCam->NextCam();
				break;
			case CAMERA_PREV_CAM:
				ManagerCam->PrevCam();
				break;
			default:
				*Consol<<"Can not file action in CAMERA_ACTION_MAP"<<std::endl;
				break;
			}

		}


		//-------------------------------------------------
		//FOG ACTION
		//-------------------------------------------------
		if(action.m_Action>START_FOG_ACTION_MAP && action.m_Action<END_FOG_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case ENABLE_FOG:
				ManagerFog->EnableFog();
				break;

			case DISABEL_FOG:
				ManagerFog->DisableFog();
				break;
			
			case SET_FOG_COLOR_R:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetFogColorR(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;

			case SET_FOG_COLOR_G:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetFogColorG(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
				
			case SET_FOG_COLOR_B:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetFogColorB(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
						
			case SET_FOG_START_POINT:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetStartPoint(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;
				
			case SET_FOG_END_POINT:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetEndPoint(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;

			case SET_FOG_DENSITY:
				try
				{
					ParamFloat=atof(Sparam.data());
					ManagerFog->SetDensity(ParamFloat);
				}catch(...)
				{
					*Consol<<"Enter a float value"<<std::endl;
				}
				break;

			case SET_FOG_ALGO_LINEAR:
				ManagerFog->SetAlgo(GL_LINEAR);
				break;

			case SET_FOG_ALGO_EXP:
				ManagerFog->SetAlgo(GL_EXP);
				break;

			case SET_FOG_ALGO_EXP2:
				ManagerFog->SetAlgo(GL_LINEAR);
				break;

			default:
				*Consol<<"Can not file action in FOG_ACTION_MAP"<<std::endl;
				break;
			}

		}

		//-------------------------------------------------
		//INTERFACE ACTION
		//-------------------------------------------------
		if(action.m_Action>START_INTERFACE_ACTION_MAP && action.m_Action<END_INTERFACE_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case ENABLE_INTERFACE:
				if(ManagerInterface->EnableInterface(Param)>0)
				{
					ManagerWindow->SetInterfaceState(true);
				}
				break;
		
			case DISABLE_INTERFACE:
				if(ManagerInterface->DisableInterface(Param)==0)
				{
					ManagerWindow->SetInterfaceState(false);
				}
				break;

			case ENABLE_ALL_INTERFACE:
				if(ManagerInterface->EnableAllInterface()>0)
				{
					ManagerWindow->SetInterfaceState(true);
				}
				break;
		
			case DISABLE_ALL_INTERFACE:
				ManagerInterface->DisableAllInterface();
				ManagerWindow->SetInterfaceState(false);
				break;

			case LIST_INTERFACE:
				ManagerInterface->ListInterface();
				break;

			case ADD_INTERFACE:
				ManagerInterface->LoadInterface(Param);
				break;

			case SHOW_INTERFACE_REGION:
				ManagerInterface->ShowRegion();
				break;

			case HIDE_INTERFACE_REGION:
				ManagerInterface->HideRegion();
				break;
				
			default:
				*Consol<<"Can not file action in INTERFACE_ACTION_MAP"<<std::endl;
				break;

			}

		}


		//-------------------------------------------------
		//SOUND ACTION
		//-------------------------------------------------
		if(action.m_Action>START_SOUND_ACTION_MAP && action.m_Action<END_SOUND_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case LIST_SOUND:
				ManagerSound->ListAllSound();
				break;

			case REMOVE_SOUND:
				ManagerSound->RemoveSound(Param);
				break;

			case PLAY_SOUND:
				ManagerSound->PlaySound(Param);
				break;

			case STOP_SOUND:
				ManagerSound->StopSound(Param);
				break;

			case ADD_SOUND:
				ManagerSound->LoadSound(Param);
				break;

			case SET_REPEATS_SOUND:
				//ManagerSound->SetRepeats(Param);
				break;

			case GET_REPEATS_SOUND:
				//ManagerSound->GetRepeats(Param);
				break;
			
			default:
				*Consol<<"Can not file action in SOUND_ACTION_MAP"<<std::endl;
				break;
			}

		}

		//-------------------------------------------------
		//MAP ACTION
		//-------------------------------------------------
		if(action.m_Action>START_MAP_ACTION_MAP && action.m_Action<END_MAP_ACTION_MAP) 
		{
			switch(action.m_Action)
			{

			case SHOW_MAP_SKY_BOX:
				ManagerMap->ShowSkybox();
				break;

			case HIDE_MAP_SKY_BOX:
				ManagerMap->HideSkybox();
				break;

			case SHOW_MAP_MESH:
				ManagerMap->ShowMesh();
				break;

			case HIDE_MAP_MESH:
				ManagerMap->HideMesh();
				break;

			case ENABLE_MAP_OCTREE:
				ManagerMap->EnableOctree();
				break;

			case DISABLE_MAP_OCTREE:
				ManagerMap->DisableOctree();
				break;

			case SHOW_MAP_OCTREE_SUBDIVISON:
				ManagerMap->ShowOctreeSubdivision();
				break;

			case HIDE_MAP_OCTREE_SUBDIVISON:
				ManagerMap->HideOctreeSubdivision();
				break;

			default:
				*Consol<<"Can not file action in MAP_ACTION_MAP"<<std::endl;
				break;
			}

		}

		//-------------------------------------------------
		//PARTICULESYSTEME ACTION
		//-------------------------------------------------
		if(action.m_Action>START_PARTICULESYSTEME_ACTION_MAP && action.m_Action<END_PARTICULESYSTEME_ACTION_MAP) 
		{
			switch(action.m_Action)
			{
			case LOAD_PARTICULESYSTEME:
				ManagerParticuleSystem->LoadParticuleSysteme(Param);
				break;

			case STAR_PARTICULESYSTEME:
				ManagerParticuleSystem->StartParticuleSysteme(Param);
				break;

			case STOP_PARTICULESYSTEME:
				ManagerParticuleSystem->StopParticuleSysteme(Param);
				break;

			case PAUSE_PARTICULESYSTEME:
				ManagerParticuleSystem->PauseParticuleSysteme(Param);
				break;

			case STAR_ALL_PARTICULESYSTEME:
				ManagerParticuleSystem->StartAllParticuleSysteme();
				break;

			case STOP_ALL_PARTICULESYSTEME:
				ManagerParticuleSystem->StopAllParticuleSysteme();
				break;

			case PAUSE_ALL_PARTICULESYSTEME:
				ManagerParticuleSystem->PauseAllParticuleSysteme();
				break;

			case LIST_PARTICULESYSTEME:
				ManagerParticuleSystem->ListParticuleSysteme();
				break;

			default:
				*Consol<<"Can not file action in PARTICULESYSTEME_ACTION_MAP"<<std::endl;
				break;
			}

		}

	//-------------------------------------------------
	//ENTITE ACTION
	//-------------------------------------------------
	if(action.m_Action>START_ENTITE_ACTION_MAP && action.m_Action<END_ENTITE_ACTION_MAP) 
	{
		SAction EntiteAction;
		
		switch(action.m_Action)
		{
		case LIST_ENTITE:
			ManagerEntite->ListEntite();
			break;

		case SET_NEXT_ENTITE_CURRENT:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->NextEntite();
			}
		break;

		case SET_CURRENT_ENTITE:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				try
				{
					ManagerEntite->SetCurrentEntite(atoi(Sparam.data()));
				}
				catch(...)
				{
					ManagerEntite->SetCurrentEntite(ManagerId->GetObjectIdByName((char *)Sparam.data()));	
				}
				
			}
		break;

		case SET_CURRENT_ENTITE_NAME:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->SetCurrentEntiteName(Sparam.data());
			}
			break;

		case ENTITE_CURRENT_INCREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_DECREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_START_INCREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_STOP_INCREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_START_DECREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_STOP_DECREASE_VELOCITY_X:
			break;

		case ENTITE_CURRENT_INCREASE_VELOCITY_Y:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite();
			}
			break;

		case ENTITE_CURRENT_DECREASE_VELOCITY_Y:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite();
			}
			break;

		case ENTITE_CURRENT_START_INCREASE_VELOCITY_Y:
			break;

		case ENTITE_CURRENT_STOP_INCREASE_VELOCITY_Y:
			break;

		case ENTITE_CURRENT_START_DECREASE_VELOCITY_Y:
			break;

		case ENTITE_CURRENT_STOP_DECREASE_VELOCITY_Y:
			break;

		case ENTITE_CURRENT_INCREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_DECREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_START_INCREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_STOP_INCREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_START_DECREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_STOP_DECREASE_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_SET_VELOCITY_X:
			break;

		case ENTITE_CURRENT_SET_VELOCITY_Y:
			break;

		case ENTITE_CURRENT_SET_VELOCITY_Z:
			break;

		case ENTITE_CURRENT_START_ROTATE_X_UP:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_X_UP;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_X_UP:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_X_UP);
			break;

		case ENTITE_CURRENT_ROTATE_X_UP:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleX++;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;

		case ENTITE_CURRENT_START_ROTATE_Y_UP:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_Y_UP;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_Y_UP:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_Y_UP);
			break;

		case ENTITE_CURRENT_ROTATE_Y_UP:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleY++;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;

		case ENTITE_CURRENT_START_ROTATE_Z_UP:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_Z_UP;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_Z_UP:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_Z_UP);
			break;

		case ENTITE_CURRENT_ROTATE_Z_UP:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleZ++;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;

		case ENTITE_CURRENT_START_ROTATE_X_DOWN:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_X_DOWN;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_X_DOWN:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_X_DOWN);
			break;

		case ENTITE_CURRENT_ROTATE_X_DOWN:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleX--;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;

		case ENTITE_CURRENT_START_ROTATE_Y_DOWN:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_Y_DOWN;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_Y_DOWN:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_Y_DOWN);
			break;

		case ENTITE_CURRENT_ROTATE_Y_DOWN:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleY--;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;

		case ENTITE_CURRENT_START_ROTATE_Z_DOWN:
			EntiteAction.m_Action=ENTITE_CURRENT_ROTATE_Z_DOWN;
			AddRepAction(EntiteAction);
			break;

		case ENTITE_CURRENT_STOP_ROTATE_Z_DOWN:
			RemoveRepAction(ENTITE_CURRENT_ROTATE_Z_DOWN);
			break;

		case ENTITE_CURRENT_ROTATE_Z_DOWN:
			if(ManagerEntite->GetNumberEntite()>0)
			{
				ManagerEntite->GetCurrentEntite()->m_AngleZ--;
				ManagerEntite->GetCurrentEntite()->Rotate();
			}
			break;
		case ENTITE_CURRENT_SET_ROTATE_X:
			break;

		case ENTITE_CURRENT_SET_ROTATE_Y:
			break;

		case ENTITE_CURRENT_SET_ROTATE_Z:
			break;
			}
		}
	


		action.m_executed=true;
		if(action.m_NextAction!=NULL)
		{
			ProcessAction(*action.m_NextAction);
		}
		return true;
	}
	action.m_executed=false;
	if(action.m_NextAction!=NULL)
	{
		ProcessAction(*action.m_NextAction);
	}
	return false;
	
	
UnGuard
}


