/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerConsole.cpp,v 1.28 2002/08/06 16:52:59 binny Exp $
 *
 */

#include "ExManagerConsole.h"

ExManagerConsole::ExManagerConsole(void)
{
Guard(ExManagerConsole::ExManagerConsole(void))
	m_ConsoleState=HIDE;
	m_LineCounter=2;
	PosIntoBuffOldCommand=0;
	m_ConsoleTransPalier=20;
	m_fBlending=0.3f;
	m_fBackGroundBlue=1.0f;
	m_fBackGroundRed=1.0f;
	m_fBackGroundGreen=1.0f;
	console_move = false;
	m_BackGroundTextureState=true;
	m_Blending = false;
	LogConsol =true;
	#ifdef UNIX_SRC
	logfilecsl.open("/tmp/logConsol.txt",ios::out);
	#else
	logfilecsl.open("logConsol.txt",ios::out);
	#endif
	logfilecsl.close();
UnGuard
}


void ExManagerConsole::Reset(void)
{
Guard(ExManagerConsole::Reset(void))
	m_ConsoleState=HIDE;
	m_LineCounter=2;
	PosIntoBuffOldCommand=0;
	m_ConsoleTransPalier=20;
	//m_BufferConsol.clear();
	m_VecStringAction.clear();
//	SetConsoleBackGroudTexture("back2.tga");
	console_move = false;
UnGuard
}

ExManagerConsole::~ExManagerConsole(void)
{
Guard(ExManagerConsole::~ExManagerConsole(void))
UnGuard
}

void ExManagerConsole::Init(void)
{
Guard(void ExManagerConsole::init(void))
	SetConsoleBackGroudTexture("back.bmp");
UnGuard
}


void ExManagerConsole::SetConsoleBackGroudTexture(const char *FileName)
{
Guard(void ExManagerConsole::SetConsoleBackGroudTexture(const char *FileName))
	m_BackGroundTexture = new char[strlen(FileName)];
	memset(m_BackGroundTexture,0,strlen(FileName));
	sprintf(m_BackGroundTexture,"%s",FileName);
	ManagerTexture->AddTexture(m_BackGroundTexture);	
UnGuard
}
void ExManagerConsole::DrawConsole(void)
{
Guard(void ExManagerConsole::DrawConsole(void))
	int i=0;
	float	textcoordy=0;
	float   cordy=0;
	char buffer[80];
	sprintf(buffer,"version %s ",VERSION);
	
	char bufferdata[255];
	sprintf(bufferdata,"]%s",m_BuffCommand.data());

	switch(m_ConsoleState)
	{
	case HIDE:
		ManagerWindow->SetConsoleState(false);
		break;

	case HALF:
		textcoordy=0.5f;
		cordy=ManagerWindow->GetResolutionY()/2;
		break;

	case FULL:
	   	textcoordy=1.0f;
		cordy=ManagerWindow->GetResolutionY();
		break;

	case HIDETOHALF:
		//cout<<"Draw hide to half "<<endl;
		textcoordy=(1.0f/m_ConsoleTransPalier)*m_ConsoleTrans;
		cordy=(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans;
		m_ConsoleTrans++;
		if(cordy>((ManagerWindow->GetResolutionY()/2)-(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case HIDETOFULL:
		//cout<<"Draw hide to full "<<endl;
		textcoordy=((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans;
		m_ConsoleTrans++;
		if(cordy>(ManagerWindow->GetResolutionY()))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case HALFTOFULL:
		//cout<<"Draw half to full"<<endl;
		textcoordy=((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans)+0.5f;
		cordy=((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans)+ManagerWindow->GetResolutionY()/2;
		m_ConsoleTrans++;
		if(cordy>(ManagerWindow->GetResolutionY()))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case FULLTOHIDE:
		//cout<<"Draw full to hide"<<endl;
		textcoordy=1.0f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=ManagerWindow->GetResolutionY()-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<0)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case FULLTOHALF:
		//cout<<"Draw full to half"<<endl;
		textcoordy=1.0f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY())-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<ManagerWindow->GetResolutionY()/2)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;
 
	case HALFTOHIDE:
		//cout<<"Draw half to hide"<<endl;
		textcoordy=0.5f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY()/2)-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<0)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;
	}
	//-------------------
	//Draw back console
	//-------------------
	
	ManagerWindow->EnterOrthoMode(0,0,ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY());
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	if(m_BackGroundTextureState)glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	ManagerTexture->SetActiveTexture(m_BackGroundTexture);
	if(m_Blending)
	{
		glColor4f(m_fBackGroundRed,m_fBackGroundGreen,m_fBackGroundBlue,m_fBlending);
		glEnable(GL_BLEND);
		glEnable(GL_ALPHA);
		glBlendFunc(GL_ONE,GL_ONE);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0);
		glDisable(GL_LIGHTING);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, textcoordy);		glVertex2f(0, 0);
			glTexCoord2f(0.0f, 0.0f);			glVertex2f(0,cordy );
			glTexCoord2f(1.0f, 0.0f);			glVertex2f(ManagerWindow->GetResolutionX(),cordy);
			glTexCoord2f(1.0f, textcoordy );	glVertex2f(ManagerWindow->GetResolutionX(),0);
		glEnd();
	}else
	{
		glColor4f(1,1,1,1);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, textcoordy);		glVertex2f(0, 0);
			glTexCoord2f(0.0f, 0.0f);			glVertex2f(0,cordy );
			glTexCoord2f(1.0f, 0.0f);			glVertex2f(ManagerWindow->GetResolutionX(),cordy);
			glTexCoord2f(1.0f, textcoordy );	glVertex2f(ManagerWindow->GetResolutionX(),0);
		glEnd();
	}
	glPopAttrib();

    //-------------------
	//Draw credits
	//-------------------
	glColor4f(0,0,1,1);
	
	RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-40,GLUT_BITMAP_8_BY_13,"ExNihilo Engine ");
	RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-30,GLUT_BITMAP_8_BY_13,buffer);
	RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-20,GLUT_BITMAP_8_BY_13,"Plok Software");
	//-------------------
	//Draw buffer console
	//-------------------
	glColor3f(0.2,0,0);
	
	std::string		bufferstring,bufferstring2;
	
	bufferstring=Consol->rdbuf( )->str();
	Consol->freeze(false);
	Consol->clear();
	Consol->flush();
	m_LineInConsol=0;
	do
	{
		bufferstring2 = bufferstring.substr(0,bufferstring.find ( "\n" ,0));
		bufferstring.erase(0,bufferstring.find ( "\n" ,0)+1);
		do
		{
			if(bufferstring2.size()>(unsigned)(ManagerWindow->GetResolutionX()/8)-1)
			{
				m_BufferConsol.push_back(bufferstring2.substr(0,((int)(ManagerWindow->GetResolutionX()/8))-1));
				bufferstring2=bufferstring2.substr(((int)(ManagerWindow->GetResolutionX()/8))-1,bufferstring2.size());
				m_LineInConsol++;
            }else
			{
				m_BufferConsol.push_back(bufferstring2);
				m_LineInConsol++;
				break;
			}
		}while(1);
	}while((unsigned)-1 != bufferstring.find( "\n" ,0));

	if(LogConsol=true)
	{
		logfilecsl.open("logConsol.txt",ios::out);
		i=0;
		for(m_ItBufferConsol=m_BufferConsol.begin();m_ItBufferConsol!=m_BufferConsol.end();m_ItBufferConsol++,i++)
		{
			logfilecsl<<i<<"::"<<m_ItBufferConsol->data()<<std::endl;					
		}
		logfilecsl.close();
	}
	i=0;

	for(m_RItBufferConsol=m_BufferConsol.rbegin();i<m_LineToStar;i++)
	{
		m_RItBufferConsol++;	
	}

	for(i=0;m_RItBufferConsol!=m_BufferConsol.rend();m_RItBufferConsol++,i++)
	{
		RenderBitmapString(10,cordy-(10*i)-20,GLUT_BITMAP_8_BY_13,m_RItBufferConsol->data());	
		if(i*10>cordy)break;
	}
	m_BufferConsol.clear();
	
	RenderBitmapString(10,cordy-10,GLUT_BITMAP_8_BY_13,bufferdata);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	ManagerWindow->LeaveOrthoMode();	
	
	if (m_ConsoleState == m_NextConsoleState && console_move == true) {
		console_move = false;
	}
	
	//DrawBuffer();	
UnGuard
}

void ExManagerConsole::LineUp(void)
{
	m_LineToStar++;
	if(m_LineToStar>m_LineInConsol)m_LineToStar=m_LineInConsol;
}
void ExManagerConsole::LineDown(void)
{
	m_LineToStar--;
	if(m_LineToStar<0){m_LineToStar=0;}
}

void ExManagerConsole::ConsoleMove (bool p) {
	console_move = p;
}

void ExManagerConsole::SetConsoleState(int state)
{
Guard(void ExManagerConsole::SetConsoleState(int state))
	//cout<<"set console state :"<<state<<endl;
	ManagerWindow->SetConsoleState(true);
	switch(m_ConsoleState)
	{
	case HIDE:
		m_NextConsoleState=state;
		switch(state)
		{
		case HALF:
			m_ConsoleState=HIDETOHALF;
			break;
		case FULL:
			m_ConsoleState=HIDETOFULL;
			break;
		}
		break;
	case HALF:
		m_NextConsoleState=state;
		switch(state)
		{
		case FULL:
			m_ConsoleState=HALFTOFULL;
			break;
		case HIDE:
			m_ConsoleState=HALFTOHIDE;
			break;
		}
		break;
	case FULL:
		m_NextConsoleState=state;
		switch(state)
		{
		case HALF:
			m_ConsoleState=FULLTOHALF;
			break;
		case HIDE:
			m_ConsoleState=FULLTOHIDE;
			break;
		}
		break;
	}
	m_ConsoleTrans=1;
UnGuard
}

int ExManagerConsole::NextAviableState(void) {
Guard(int ExManagerConsole::NextAviableState(void))
	switch(m_ConsoleState) {
		case HIDE: return HALF;
		case HALF: return FULL;
		case FULL: return HIDE;
		case HIDETOHALF	: return HALF;
		case HIDETOFULL : return FULL;
		case HALFTOFULL	: return FULL;
		case FULLTOHALF	: return HALF;
		case FULLTOHIDE	: return HIDE;
		case HALFTOHIDE	: return HIDE;
		default: return HALF;
	}
UnGuard
}

void ExManagerConsole::Write(const char *Label)
{
Guard(void ExManagerConsole::Write(const char *Label))
	//*Consol<<"<<==================Write to consol===========================>>"<<std::endl;
	*Consol << Label << std::endl;
	//*Consol<<"<<============================================================>>"<<std::endl;
UnGuard
}

SAction ExManagerConsole::InputCommand(int command,int mousex,int mousey)
{
Guard(SAction ExManagerConsole::InputCommand(int command,int mousex,int mousey))
	switch(command)
	{
	case KEYBOARD_DOWN_EXP: 
		return CONSOL_NEXT_AVIABLE_STATE;	
	
	case KEYBOARD_DOWN_ESC: 
		return HIDE_CONSOL;
	
	case KEYBOARD_DOWN_A:
		m_BuffCommand.append("a"); 
		return NOTHING;
	
	case KEYBOARD_DOWN_Z:
		m_BuffCommand.append("z");
		return NOTHING;
	
	case KEYBOARD_DOWN_E:
		m_BuffCommand.append("e");
		return NOTHING;
	
	case KEYBOARD_DOWN_R:
		m_BuffCommand.append("r");
		return NOTHING;
	
	case KEYBOARD_DOWN_T:
		m_BuffCommand.append("t");
		return NOTHING;
	
	case KEYBOARD_DOWN_Y:
		m_BuffCommand.append("y");
		return NOTHING;
	
	case KEYBOARD_DOWN_U:
		m_BuffCommand.append("u");
		return NOTHING;
	case KEYBOARD_DOWN_I:
		m_BuffCommand.append("i");
		return NOTHING;

	case KEYBOARD_DOWN_O:
		m_BuffCommand.append("o");
		return NOTHING;

	case KEYBOARD_DOWN_P:
		m_BuffCommand.append("p");
		return NOTHING;

	case KEYBOARD_DOWN_Q:
		m_BuffCommand.append("q");
		return NOTHING;

	case KEYBOARD_DOWN_S:
		m_BuffCommand.append("s");
		return NOTHING;

	case KEYBOARD_DOWN_D:
		m_BuffCommand.append("d");
		return NOTHING;

	case KEYBOARD_DOWN_F:
		m_BuffCommand.append("f");
		return NOTHING;

	case KEYBOARD_DOWN_G:
		m_BuffCommand.append("g");
		return NOTHING;

	case KEYBOARD_DOWN_H:
		m_BuffCommand.append("h");
		return NOTHING;

	case KEYBOARD_DOWN_J:
		m_BuffCommand.append("j");
		return NOTHING;

	case KEYBOARD_DOWN_K:
		m_BuffCommand.append("k");
		return NOTHING;

	case KEYBOARD_DOWN_L:
		m_BuffCommand.append("l");
		return NOTHING;

	case KEYBOARD_DOWN_M:
		m_BuffCommand.append("m");
		return NOTHING;

	case KEYBOARD_DOWN_W:
		m_BuffCommand.append("w");
		return NOTHING;

	case KEYBOARD_DOWN_X:
		m_BuffCommand.append("x");
		return NOTHING;

	case KEYBOARD_DOWN_C:
		m_BuffCommand.append("c");
		return NOTHING;

	case KEYBOARD_DOWN_V:
		m_BuffCommand.append("v");
		return NOTHING;

	case KEYBOARD_DOWN_B:
		m_BuffCommand.append("b");
		return NOTHING;

	case KEYBOARD_DOWN_N:
		m_BuffCommand.append("n");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_A:
		m_BuffCommand.append("A"); 
		return NOTHING;
	
	case KEYBOARD_DOWN_M_Z:
		m_BuffCommand.append("Z");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_E:
		m_BuffCommand.append("E");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_R:
		m_BuffCommand.append("R");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_T:
		m_BuffCommand.append("T");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_Y:
		m_BuffCommand.append("Y");
		return NOTHING;
	
	case KEYBOARD_DOWN_M_U:
		m_BuffCommand.append("U");
		return NOTHING;
	case KEYBOARD_DOWN_M_I:
		m_BuffCommand.append("I");
		return NOTHING;

	case KEYBOARD_DOWN_M_O:
		m_BuffCommand.append("O");
		return NOTHING;

	case KEYBOARD_DOWN_M_P:
		m_BuffCommand.append("P");
		return NOTHING;

	case KEYBOARD_DOWN_M_Q:
		m_BuffCommand.append("Q");
		return NOTHING;

	case KEYBOARD_DOWN_M_S:
		m_BuffCommand.append("S");
		return NOTHING;

	case KEYBOARD_DOWN_M_D:
		m_BuffCommand.append("D");
		return NOTHING;

	case KEYBOARD_DOWN_M_F:
		m_BuffCommand.append("F");
		return NOTHING;

	case KEYBOARD_DOWN_M_G:
		m_BuffCommand.append("G");
		return NOTHING;

	case KEYBOARD_DOWN_M_H:
		m_BuffCommand.append("H");
		return NOTHING;

	case KEYBOARD_DOWN_M_J:
		m_BuffCommand.append("J");
		return NOTHING;

	case KEYBOARD_DOWN_M_K:
		m_BuffCommand.append("K");
		return NOTHING;

	case KEYBOARD_DOWN_M_L:
		m_BuffCommand.append("L");
		return NOTHING;

	case KEYBOARD_DOWN_M_M:
		m_BuffCommand.append("M");
		return NOTHING;

	case KEYBOARD_DOWN_M_W:
		m_BuffCommand.append("W");
		return NOTHING;

	case KEYBOARD_DOWN_M_X:
		m_BuffCommand.append("X");
		return NOTHING;

	case KEYBOARD_DOWN_M_C:
		m_BuffCommand.append("C");
		return NOTHING;

	case KEYBOARD_DOWN_M_V:
		m_BuffCommand.append("V");
		return NOTHING;

	case KEYBOARD_DOWN_M_B:
		m_BuffCommand.append("B");
		return NOTHING;

	case KEYBOARD_DOWN_M_N:
		m_BuffCommand.append("N");
		return NOTHING;

	case KEYBOARD_DOWN_0:
		m_BuffCommand.append("0");
		return NOTHING;

	case KEYBOARD_DOWN_1:
		m_BuffCommand.append("1");
		return NOTHING;

	case KEYBOARD_DOWN_2:
		m_BuffCommand.append("2");
		return NOTHING;

	case KEYBOARD_DOWN_3:
		m_BuffCommand.append("3");
		return NOTHING;

	case KEYBOARD_DOWN_4:
		m_BuffCommand.append("4");
		return NOTHING;

	case KEYBOARD_DOWN_5:
		m_BuffCommand.append("5");
		return NOTHING;

	case KEYBOARD_DOWN_6:
		m_BuffCommand.append("6");
		return NOTHING;

	case KEYBOARD_DOWN_7:
		m_BuffCommand.append("7");
		return NOTHING;

	case KEYBOARD_DOWN_8:
		m_BuffCommand.append("8");
		return NOTHING;

	case KEYBOARD_DOWN_9:
		m_BuffCommand.append("9");
		return NOTHING;

	case KEYBOARD_DOWN__:
		m_BuffCommand.append("_");
		return NOTHING;

	case KEYBOARD_DOWN_2POINTS:
		m_BuffCommand.append(":");
		return NOTHING;

	case KEYBOARD_DOWN_POINT:
		m_BuffCommand.append(".");
		return NOTHING;

	case KEYBOARD_UP_PAGE_UP:
		LineUp();
		return NOTHING;
	
	case KEYBOARD_UP_PAGE_DOWN:
		LineDown();
		return NOTHING;

	case KEYBOARD_DOWN_SPACE:
		m_BuffCommand.append(" ");
		return NOTHING;

	case KEYBOARD_DOWN_ENTER:
		return ApplyBuffCommand();
	
	case KEYBOARD_DOWN_TAB: {
		std::vector<std::string> vec_tmp;
		std::vector<std::string>::iterator i_tmp;
		
		vec_tmp.push_back ("load");
		vec_tmp.push_back ("cmd");
		vec_tmp.push_back ("help");
		vec_tmp.push_back ("clear");
		vec_tmp.push_back ("quit");
		
		for (m_ItVecStringAction = m_VecStringAction.begin(); m_ItVecStringAction != m_VecStringAction.end(); m_ItVecStringAction++) {
			vec_tmp.push_back (m_ItVecStringAction->first);
		}
		
		i_tmp = vec_tmp.begin ();
		std::string tmp;
		
		while (i_tmp != vec_tmp.end ()) {
			tmp = *i_tmp++;
		
			if (tmp.find (m_BuffCommand) == 0) {
				if (tmp.find (' ') < tmp.length ())
					m_BuffCommand = tmp.substr (0, tmp.find (' '));
				else m_BuffCommand = tmp;
				//m_BuffCommand += ' '; // this add a space after command
				// but it sucks with some commands like quit :/
			}
		}
		return NOTHING;
	}
	case KEYBOARD_DOWN_CTRL_U:
		m_BuffCommand = ""; 
		return NOTHING;
	
	case KEYBOARD_UP_ARROW_DOWN:
		PosIntoBuffOldCommand++;
		if(PosIntoBuffOldCommand<(int)m_BuffOldCommand.size()&&PosIntoBuffOldCommand>=-1)
		{
			m_BuffCommand=m_BuffOldCommand.at(PosIntoBuffOldCommand);			
		}else
		{
			PosIntoBuffOldCommand=0;
		}


		return NOTHING;
	
	case KEYBOARD_UP_ARROW_UP:
		PosIntoBuffOldCommand--;
		if(PosIntoBuffOldCommand<(int)m_BuffOldCommand.size()&&PosIntoBuffOldCommand>=0)
		{
			m_BuffCommand=m_BuffOldCommand.at(PosIntoBuffOldCommand);			
		}else
		{
			PosIntoBuffOldCommand=0;
		}
		return NOTHING;
	
	case KEYBOARD_UP_ARROW_LEFT:
		if(m_BuffCommand.size()>0)
		{
			m_BuffCommand.erase(m_BuffCommand.end()-1,m_BuffCommand.end());
		}
		return NOTHING;
	
	case KEYBOARD_UP_BACKSPACE:
		if(m_BuffCommand.size()>0)
		{
			m_BuffCommand.erase(m_BuffCommand.end()-1,m_BuffCommand.end());
		}
		return NOTHING;

	default :return NOTHING;
	}
UnGuard
}

void ExManagerConsole::ListConsoleCommand(void)
{
Guard(void ExManagerConsole::ListConsoleCommand(void))
	*Consol<<"*******************************"<<std::endl;
	*Consol<<"*List of all available command*"<<std::endl;
	*Consol<<"*******************************"<<std::endl;
	*Consol<<"load 'FILENAME'"<<std::endl;
	*Consol<<"cmd 'number of command'"<<std::endl;;
	*Consol<<"help 'command'"<<std::endl;
	*Consol<<"clear 'clear console screen'"<<std::endl;
	*Consol<<"quit 'exit ExNihilo'"<<std::endl;
	int i=PREDIFINEDCOMMAND;
	for(m_ItVecStringAction=m_VecStringAction.begin(); m_ItVecStringAction != m_VecStringAction.end(); m_ItVecStringAction++, i++) 
	{
		*Consol<<i<<") "<<m_ItVecStringAction->first.data()<<std::endl;
	}
	*Consol<<"*****************************"<<std::endl;
UnGuard
}

SAction ExManagerConsole::ApplyBuffCommand(void)
{
Guard(SAction ExManagerConsole::ApplyBuffCommand(void))
bool findaction=false;
	SAction Action;
	Action.m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
	*Consol<<m_BuffCommand.data()<<std::endl;
	for(m_ItVecStringAction=m_VecStringAction.begin();m_ItVecStringAction!=m_VecStringAction.end();m_ItVecStringAction++)
	{
		if(m_BuffCommand.find(m_ItVecStringAction->first.data())==0)
		{			 
			findaction=true;
			char buffer[255];
			memset(buffer,0,255);
			Action.m_Action=m_ItVecStringAction->second;
			m_BuffCommand.copy(buffer,(m_BuffCommand.size())-(strlen(m_ItVecStringAction->first.data())),strlen(m_ItVecStringAction->first.data()));
			Action.SetParam(buffer);
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
		}	    
	}
	if(!findaction)
	{
		if(strcmp(m_BuffCommand.data(),"clear")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			m_BufferConsol.clear();
			ClearConsol();
			Action.m_Action= NOTHING;
			return Action;
		}
		
		if(m_BuffCommand.find("help")==0)
		{
			ListConsoleCommand();
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= NOTHING;
			return Action;
		}
		if(m_BuffCommand.find("cmd ")==0)
		{
			int cmd=0;
			char *SBuffer;
			SBuffer=new char[strlen(m_BuffCommand.data())-5] ;
			memset(SBuffer,0,strlen(m_BuffCommand.data()));
			m_BuffCommand.copy(SBuffer,m_BuffCommand.size()-4,4);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			try
			{
				cmd=atoi(SBuffer);
				Action.m_Action= m_VecStringAction.at(cmd-PREDIFINEDCOMMAND).second;
			}catch(...)
			{
				*Consol<<"Bad argument use list to show command list"<<std::endl;
				Action.m_Action= NOTHING;
				return Action;
			}
		}

		if(strcmp(m_BuffCommand.data(),"quit")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= QUIT;
			return Action;
		}
		
		if(strcmp(m_BuffCommand.data(),"reset")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= RESET;
			return Action;
		}

		if(m_BuffCommand.find("load")!=(unsigned)-1)
		{
			char buffer[255];
			memset(buffer,0,255);
			Action.m_Action=LOAD_FILE;
			m_BuffCommand.copy(buffer,m_BuffCommand.size()-4,4);
			Action.SetParam(buffer);
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			return Action;
		}
		
		*Consol<<"Unknow command"<<std::endl;
		m_BuffOldCommand.push_back(m_BuffCommand);
		m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
		Action.m_Action= NOTHING;
	}
	return Action;
UnGuard
}

void ExManagerConsole::AddStringAction(const char *String,int Action)
{
Guard(void ExManagerConsole::AddStringAction(const char *String,int Action))
	StringAction ac;
	ac.first=String;
	ac.second=Action;
	m_VecStringAction.push_back(ac);
	*Consol<<"Add new command to console command:"<<String<<" Action:"<<Action<<std::endl;
UnGuard
}

void ExManagerConsole::AddStringAction(StringAction StrAction)
{
Guard(void ExManagerConsole::AddStringAction(StringAction StrAction))
	AddStringAction(StrAction.first.data(),StrAction.second);
UnGuard
}

void ExManagerConsole::AddStringAction(ExCFileDataAction p) {
Guard(void ExManagerConsole::AddStringAction(ExCFileDataAction p))
	StringAction foo;
	foo.first = p.getAction();
	foo.second = p.getCommand();
	AddStringAction(foo);
UnGuard
}

void ExManagerConsole::LoadStringActionFile(const char *FileName)
{
Guard(void ExManagerConsole::LoadStringActionFile(const char *FileName))
    char			buffer[255];
	
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Console/%s", FileName);
#else
	sprintf(buffer, "../Data/Console/%s", FileName);
#endif
    
	ExCFileReader my_file (buffer);
	if (! my_file.exist()) 
	{
		*Consol<<"File not found: "<<buffer<<std::endl;
	} else {
		*Consol<<"Loading Command File: "<<FileName<<std::endl;
	
		ExCFileData _data = my_file.getContent();
		if (_data.getType() != FILE_CONSOLE) 
		{
			*Consol<<FileName<<" is not a valide console file"<<std::endl;
		} else 
		{
			vector<ExCFileDataAction> dd = _data.getContent();
			vector<ExCFileDataAction>::iterator i = dd.begin ();
			ExCFileDataAction f;
			while (i != dd.end ()) 
			{
				f = *i++;
				AddStringAction (f);
			}
		}
	}
UnGuard
}

void ExManagerConsole::ClearConsol(void)
{
Guard(void ExManagerConsole::ClearConsol(void))
	m_BuffOldCommand.push_back(m_BuffCommand);
	m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
	m_BufferConsol.clear();
UnGuard
}
