/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerEntite.cpp,v 1.11 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExManagerEntite.h"

ExManagerEntite::ExManagerEntite(void)
{
Guard(ExManagerEntite::ExManagerEntite(void))
	m_VecPObject	= new std::vector<ExCEntite *>;
	m_VecEntite		= new std::vector<ExCEntite>;
	m_VecComposed	= new std::vector<ExCComposed>;
	m_VecSkeleton	= new std::vector<ExSkeleton>;
	m_CurrentEntite=-1;
UnGuard
}


ExManagerEntite::~ExManagerEntite(void)
{
Guard(ExManagerEntite::~ExManagerEntite(void))
UnGuard
}

//---------------------------------------------------------
bool ExManagerEntite::LoadModel(const char * FileName)
{
Guard(bool ExManagerEntite::LoadModel(const char *FileName))
	std::string	SFileName(FileName);
	//cheking file extension to know model type
	if(SFileName.find(".md2")==(SFileName.length()-4))
	{
	}
	if(SFileName.find(".md3")==(SFileName.length()-4))
	{
	}
	if(SFileName.find(".asc")==(SFileName.length()-4))
	{
	}
	if(SFileName.find(".ase")==(SFileName.length()-4))
	{
	}
	if(SFileName.find(".3ds")==(SFileName.length()-4))
	{
	}
	if(SFileName.find(".obj")==(SFileName.length()-4))
	{
	}
	WriteToConsol(SFileName.data());
	return true;
UnGuard
}	

void  ExManagerEntite::Reset(void)
{
Guard(void  ExManagerEntite::Reset(void))
	m_VecPObject->clear();
	m_VecEntite->clear();
	m_VecComposed->clear();
	m_VecSkeleton->clear();
	RecordToManagerPVS();
UnGuard
}

void ExManagerEntite::ListEntite(void)
{
Guard(void ExManagerEntite::ListEntite(void))
	int i=0;
	*Consol<<"**********************"<<std::endl;
	*Consol<<"*List of all entites *"<<std::endl;
	*Consol<<"**********************"<<std::endl;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		*Consol<<"Object ID:"<<m_VecPObject->at(i)->GetId()<<" Name:"<<m_VecPObject->at(i)->GetName();
		*Consol<<" Postion X:"<<m_VecPObject->at(i)->GetPosition().GetX()<<" Y:"<<m_VecPObject->at(i)->GetPosition().GetY();
		*Consol<<" Z:"<<m_VecPObject->at(i)->GetPosition().GetZ()<<std::endl;
	}
	*Consol<<"**********************"<<std::endl;
	*Consol<<"Current Entite Id :"<<m_CurrentEntite<<std::endl;
	*Consol<<"**********************"<<std::endl;
UnGuard
}

void  ExManagerEntite::Init(void)
{
Guard(void  ExManagerEntite::Init(void))
	RecordToManagerPVS();
UnGuard
}


void ExManagerEntite::LoadAsc(const char *FileName)
{
Guard(void ExManagerEntite::LoadAsc(const char *FileName))
	char *Buffer;
	ExCComposed Entite;
	Entite.SetManagerTexture(ManagerTexture);
	Buffer= new char[strlen(FileName)+40];
#ifdef UNIX_SRC
	sprintf(Buffer, PREFIX "/ExNihilo/Data/Modeles/%s",FileName);
#else
	sprintf(Buffer, "../Data/Modeles/%s",FileName);
#endif
	if(Entite.LoadAsc(Buffer))
	{
		Add(Entite);	
	}else
	{
		*Consol<<"File not found"<<std::endl;
	}
UnGuard
}

void ExManagerEntite::MakeGlListForAll(void)
{
  	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		m_VecPObject->at(i)->MakeList();
	}
}

bool  ExManagerEntite::Init(char * FileName)
{
Guard(bool  ExManagerEntite::Init(char * FileName))
	//openf file and load object
	return true;
UnGuard
}


ExId  ExManagerEntite::NewObject(void)
{
Guard(ExId  ExManagerEntite::NewObject(void))
	char *Name;	
	ExCEntite Entite1;
	Name= new char[strlen("ENTITE ")+3];
	sprintf(Name,"ENTITE %d",m_VecEntite->size()+1);
	Entite1.SetIdName(ManagerId->GetNewIdName(Name));
	Entite1.SetManagerTexture(ManagerTexture);
	Entite1.SetCurrentState(true);
	m_VecEntite->push_back(Entite1);
	m_VecPObject->push_back(&m_VecEntite->at(m_VecEntite->size()-1));
	Get(m_CurrentEntite)->SetCurrentState(false);
	m_CurrentEntite=Entite1.GetId();
	return m_CurrentEntite;
UnGuard
}

ExId  ExManagerEntite::Add(ExCEntite Object)
{
Guard(ExId ExManagerEntite::Add(ExCEntite Object))
	Object.SetIdName(ManagerId->GetNewIdName(Object.GetName()));
	Object.SetManagerTexture(ManagerTexture);
	Object.SetCurrentState(true);
	m_VecEntite->push_back(Object);
	m_CurrentEntite=Object.GetId();
	CreateVecPobject();
	return m_CurrentEntite;
UnGuard
}

ExId  ExManagerEntite::Add(ExCComposed Object)
{
Guard(ExId ExManagerEntite::Add(ExCComposed Object))
	Object.SetIdName(ManagerId->GetNewIdName(Object.GetName()));
	Object.SetManagerTexture(ManagerTexture);
	Object.SetCurrentState(true);
	m_VecComposed->push_back(Object);
	m_CurrentEntite=Object.GetId();
	CreateVecPobject();
	return m_CurrentEntite;
UnGuard
}

void ExManagerEntite::CreateVecPobject(void)
{
	m_VecPObject->clear();

	int i=0;
	for(m_ItVecEntite=m_VecEntite->begin();m_ItVecEntite!=m_VecEntite->end();m_ItVecEntite++,i++)
	{
		m_VecPObject->push_back(&m_VecEntite->at(i));
	}
	i=0;
	for(m_ItVecComposed=m_VecComposed->begin();m_ItVecComposed!=m_VecComposed->end();m_ItVecComposed++,i++)
	{
		m_VecPObject->push_back(&m_VecComposed->at(i));
	}
	 *Consol<<"Nuber of Entite :"<<m_VecPObject->size()<<std::endl;
}




ExCEntite *  ExManagerEntite::Get(char * Name)
{
Guard(ExCEntite * ExManagerEntite::Get(char * Name))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(strcmp(m_VecPObject->at(i)->GetName(),Name)==0)
		{
			return m_VecPObject->at(i);
		}
	}
	return NULL;
UnGuard
}


ExCEntite * ExManagerEntite::Get(ExId Id)
{
Guard(ExCEntite * ExManagerEntite::Get(ExId Id))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==Id)
		{
			return m_VecPObject->at(i);
		}
	}
	return NULL;	
UnGuard
}





bool  ExManagerEntite::Remove(ExId Id)
{
Guard(bool ExManagerEntite::Remove(ExId Id))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==Id)
		{
			
			//m_VecPObject->at(i)->erase(m_ItVecEntite);

			return true;
		}
	}
	return false;
UnGuard
}


ExCEntite *  ExManagerEntite::GetCurrentEntite(void)
{
Guard(ExCEntite *  ExManagerEntite::GetCurrentEntite(void))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==m_CurrentEntite)
		{
			return m_VecPObject->at(i);
		}
	}
UnGuard
return NULL;
}

void  ExManagerEntite::NextEntite(void)
{
Guard(void  ExManagerEntite::NextEntite(void))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		m_VecPObject->at(i)->SetCurrentState(false);
	}
	i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==m_CurrentEntite)
		{
			m_ItVecPObject++;
			if(m_ItVecPObject==m_VecPObject->end())//this is the last
			{
				m_ItVecPObject=m_VecPObject->begin();
				m_CurrentEntite=m_VecPObject->at(0)->GetId();
				m_VecPObject->at(0)->SetCurrentState(true);
				break;
			}else
			{
				m_CurrentEntite=m_VecPObject->at(i+1)->GetId();
				m_VecPObject->at(i+1)->SetCurrentState(true);
				break;
			}
			m_ItVecPObject--;
		}  
	}
	*Consol<<"Current Entite :"<<m_CurrentEntite<<std::endl;
UnGuard
}

void  ExManagerEntite::PrevEntite(void)
{
Guard(void  ExManagerEntite::PrevEntite(void))
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		m_VecPObject->at(i)->SetCurrentState(false);
	}
	i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==m_CurrentEntite)
		{
			if(m_ItVecPObject==m_VecPObject->begin())
			{
				m_ItVecPObject=m_VecPObject->end()-1;
			}else
			{
				m_ItVecPObject--;
			}
			m_CurrentEntite=m_VecPObject->at(i)->GetId();
			m_VecPObject->at(i)->SetCurrentState(true);
		}
	}
	*Consol<<"Current Entite :"<<m_CurrentEntite<<std::endl;
UnGuard
}

bool  ExManagerEntite::SetCurrentEntite(ExId Id)
{
Guard(void  ExManagerEntite::SetCurrentEntite(ExId Id))
	//checking if id exist before !!!
	int i=0;
	for(m_ItVecPObject=m_VecPObject->begin();m_ItVecPObject!=m_VecPObject->end();m_ItVecPObject++,i++)
	{
		if(m_VecPObject->at(i)->GetId()==Id)
		{
			m_CurrentEntite=Id;
			*Consol<<"Current Entite :"<<m_CurrentEntite<<std::endl;
			return true;
		}
	}
	*Consol<<"MESSAGE FROM MANAGER ENTITE :: Entite Id :"<<Id<<"not found"<<std::endl;
	return false;
UnGuard
}

bool  ExManagerEntite::SetCurrentEntiteName(const char *Name)
{
Guard(void  ExManagerEntite::SetCurrentEntiteName(const char *Name))
	if(ManagerId->isNameAviable((char *)Name) )
	{
		ManagerId->RemoveIdName((char *)Name);
		if(ManagerId->RecordIdName(GetCurrentEntite()->GetId(),(char *)Name))
		{
			GetCurrentEntite()->SetName(Name);
			*Consol<<"MESSAGE FROM MANAGER ENTITE ::Name changed for Entite Id :"<<GetCurrentEntite()->GetId()<<" new name:"<<GetCurrentEntite()->GetName()<<std::endl;
			return true;
		}
	}
	*Consol<<"MESSAGE FROM MANAGER ENTITE ::Name already take by Entite Id :"<<ManagerId->GetObjectIdByName((char *)Name)<<std::endl;
	return false;
UnGuard
}

 
