/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerFog.cpp,v 1.4 2002/06/15 22:40:17 binny Exp $
 *
 */

#include "ExManagerFog.h"

ExManagerFog::ExManagerFog(void)
{
Guard(ExManagerFog::ExManagerFog(void))
	Reset();
UnGuard
}

ExManagerFog::~ExManagerFog(void)
{
Guard(ExManagerFog::~ExManagerFog(void))
UnGuard
}

void ExManagerFog::Reset(void)
{
Guard(ExManagerFog::Reset(void))
	SetAlgo(GL_LINEAR);
	SetFogColor(0.2f,0.2f,0.2f,1.0f);
	SetStartPoint(50.0f);
	SetEndPoint(100.0f);
	SetDensity(0.30);
	m_State=false;
UnGuard
}

void ExManagerFog::EnableFog(void)
{
Guard(ExManagerFog::EnableFog(void))
	glEnable(GL_FOG);
	glFogi(GL_FOG_MODE,m_FogAlgo);//GL_EXP,GL_EXP2,GL_LINEAR
	glFogfv(GL_FOG_COLOR,m_FogColor);
	glFogf(GL_FOG_DENSITY,m_Density);
	glHint(GL_FOG_HINT,GL_DONT_CARE);
	glFogf(GL_FOG_START,m_StartPoint);
	glFogf(GL_FOG_END,m_EndPoint);
	m_State=true;
UnGuard
}

void ExManagerFog::DisableFog(void)
{
Guard(ExManagerFog::DisableFog(void))
	glDisable(GL_FOG);
	m_State=false;
UnGuard
}


void ExManagerFog::SetFogColor(float R,float G,float B,float A)
{
Guard(ExManagerFog::SetFogColor(float R,float G,float B,float A))
	SetFogColorR(R);
	SetFogColorG(G);
	SetFogColorB(B);
	SetFogColorA(A);
UnGuard
}

void ExManagerFog::SetFogColorR(float R)
{
Guard(ExManagerFog::SetFogColorR(float R))
	if(R>1.0f)R=1.0f;
	if(R<0.0f)R=0.0f;
	m_FogColor[0]=R;
	glFogfv(GL_FOG_COLOR,m_FogColor);
UnGuard
}

void ExManagerFog::SetFogColorG(float G)
{
Guard(ExManagerFog::SetFogColorG(float G))
	if(G>1.0f)G=1.0f;
	if(G<0.0f)G=0.0f;
	m_FogColor[1]=G;
	glFogfv(GL_FOG_COLOR,m_FogColor);
UnGuard
}

void ExManagerFog::SetFogColorB(float B)
{
Guard(ExManagerFog::SetFogColorB(float B))
	if(B>1.0f)B=1.0f;
	if(B<0.0f)B=0.0f;
	m_FogColor[2]=B;
	glFogfv(GL_FOG_COLOR,m_FogColor);
UnGuard
}

void ExManagerFog::SetFogColorA(float A)
{
Guard(ExManagerFog::SetFogColorA(float A))
	if(A>1.0f)A=1.0f;
	if(A<0.0f)A=0.0f;
	m_FogColor[3]=A;
	glFogfv(GL_FOG_COLOR,m_FogColor);
UnGuard
}

void ExManagerFog::IncFogColorR(float inc)
{
Guard(ExManagerFog::IncFogColorR(float inc))
	SetFogColorR(GetFogColorR()+inc);
UnGuard
}

void ExManagerFog::IncFogColorG(float inc)
{
Guard(ExManagerFog::IncFogColorG(float inc))
	SetFogColorG(GetFogColorG()+inc);
UnGuard
}

void ExManagerFog::IncFogColorB(float inc)
{
Guard(ExManagerFog::IncFogColorB(float inc))
	SetFogColorB(GetFogColorB()+inc);
UnGuard
}

void ExManagerFog::IncFogColorA(float inc)
{
Guard(ExManagerFog::IncFogColorA(float inc))
	SetFogColorA(GetFogColorA()+inc);
UnGuard
}

void ExManagerFog::SetStartPoint(float P)
{
Guard(ExManagerFog::SetStartPoint(float P))
	m_StartPoint=P;
	glFogf(GL_FOG_START,m_StartPoint);
UnGuard
}

void ExManagerFog::IncStartPoint(float inc)
{
Guard(ExManagerFog::IncStartPoint(float inc))
	SetStartPoint(GetStarPoint()+inc);
UnGuard
}

void ExManagerFog::SetEndPoint(float P)
{
Guard(ExManagerFog::SetEndPoint(float P))
	m_EndPoint=P;
	glFogf(GL_FOG_END,m_EndPoint);
UnGuard
}

void ExManagerFog::IncEndPoint(float inc)
{
Guard(ExManagerFog::IncEndPoint(float inc))
	SetEndPoint(GetEndPoint()+inc);
UnGuard
}

void ExManagerFog::SetDensity(float P)
{
Guard(ExManagerFog::SetDensity(float P))
	m_Density=P;
	glFogf(GL_FOG_DENSITY,m_Density);
UnGuard
}

void ExManagerFog::IncDensity(float inc)
{
Guard(ExManagerFog::IncDensity(float inc))
	SetDensity(GetDensity()+inc);
UnGuard
}

void ExManagerFog::SetAlgo(GLenum algo)
{
Guard(ExManagerFog::SetAlgo(GLenum algo))
	switch(algo)
	{
		case GL_LINEAR:
			m_FogAlgo=GL_LINEAR;
			glFogi(GL_FOG_MODE,GL_LINEAR);
			break;
		case GL_EXP:
			m_FogAlgo=GL_EXP;
			glFogi(GL_FOG_MODE,GL_EXP);
			break;
		case GL_EXP2:
			m_FogAlgo=GL_EXP2;
			glFogi(GL_FOG_MODE,GL_EXP2);
			break;
		default :
			m_FogAlgo=GL_LINEAR;
			glFogi(GL_FOG_MODE,GL_LINEAR);
			break;
	}
UnGuard
}
