/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerGizmo.cpp,v 1.5 2002/08/01 01:18:22 data Exp $
 *
 */

#include "ExManagerGizmo.h"

ExManagerGizmo::ExManagerGizmo(void)
{
Guard(ExManagerGizmo::ExManagerGizmo(void))
UnGuard
}


ExManagerGizmo::~ExManagerGizmo(void)
{
Guard(ExManagerGizmo::~ExManagerGizmo(void))
UnGuard
}


void  ExManagerGizmo::Reset(void)
{
Guard(void  ExManagerGizmo::Reset(void))
	m_VecGizmo.clear();
UnGuard
}


void  ExManagerGizmo::Init(void)
{
Guard(void  ExManagerGizmo::Init(void))
UnGuard
}


bool  ExManagerGizmo::Init(char * FileName)
{
Guard(bool  ExManagerGizmo::Init(char * FileName))
	//openf file and load object
	return true;
UnGuard
}


ExId  ExManagerGizmo::NewObject(void)
{
Guard(ExId  ExManagerGizmo::NewObject(void))
	ExCGizmo NewGizmo;
	m_VecGizmo.push_back(NewGizmo);
	return NewGizmo.GetId();
UnGuard
}


ExCGizmo *  ExManagerGizmo::Get(char * Name)
{
Guard(ExCGizmo *  ExManagerGizmo::Get(char * Name))
	int i=0;
	for(m_ItVecGizmo=m_VecGizmo.begin();m_ItVecGizmo!=m_VecGizmo.end();m_ItVecGizmo++,i++)
	{
		if(strcmp(m_ItVecGizmo->GetName(),Name)==0)
		{
			return &m_VecGizmo.at(i);
		}
	}
	return NULL;
UnGuard
}


ExCGizmo *  ExManagerGizmo::Get(ExId Id)
{
Guard(ExCGizmo *  ExManagerGizmo::Get(ExId Id))
	int i=0;
	for(m_ItVecGizmo=m_VecGizmo.begin();m_ItVecGizmo!=m_VecGizmo.end();m_ItVecGizmo++,i++)
	{
		if(m_ItVecGizmo->GetId()==Id)
		{
			return &m_VecGizmo.at(i);
		}
	}
	return NULL;	
UnGuard
}


ExId  ExManagerGizmo::Add(ExCGizmo Object)
{
Guard(ExId ExManagerGizmo::Add(ExCGizmo Object))
	m_VecGizmo.push_back(Object);
	return Object.GetId();
UnGuard
}


bool  ExManagerGizmo::Remove(ExId Id)
{
Guard(bool ExManagerGizmo::Remove(ExId Id))
	for(m_ItVecGizmo=m_VecGizmo.begin();m_ItVecGizmo!=m_VecGizmo.end();m_ItVecGizmo++)
	{
		if(m_ItVecGizmo->GetId()==Id)
		{
			m_VecGizmo.erase(m_ItVecGizmo);
			return true;
		}
	}
	return false;
UnGuard
}


ExId  ExManagerGizmo::GetIdByName(char *Name)
{
Guard(ExId ExManagerGizmo::GetIdByName(char *Name))
	for(m_ItVecGizmo=m_VecGizmo.begin();m_ItVecGizmo!=m_VecGizmo.end();m_ItVecGizmo++)
	{
		if(strcmp(m_ItVecGizmo->GetName(),Name)==0)
		{
			return m_ItVecGizmo->GetId();
		}
	}
	return -1;
UnGuard
}


char * ExManagerGizmo::GetNameById(ExId Id)
{
Guard(char * ExManagerGizmo::GetNameById(ExId Id))
	for(m_ItVecGizmo=m_VecGizmo.begin();m_ItVecGizmo!=m_VecGizmo.end();m_ItVecGizmo++)
	{
		if(m_ItVecGizmo->GetId()==Id)
		{
			return m_ItVecGizmo->GetName();
		}
	}
	return NULL;
UnGuard
}
